/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest;

import com.robothy.s3.rest.bootstrap.LocalS3Bootstrap;
import com.robothy.s3.rest.bootstrap.Mode;
import java.io.InputStream;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;

public class LocalS3Launcher {
    public static void main(String[] args) {
        if (args.length == 0 || !Mode.PERSISTENCE.name().equalsIgnoreCase(args[0]) && !Mode.IN_MEMORY.name().equalsIgnoreCase(args[0])) {
            System.out.println("Usage:    java -jar local-s3.jar [persist | in_memory]");
            System.exit(0);
        }
        System.setProperty("s3.port", "18080");
        Properties properties = LocalS3Launcher.loadProperties();
        LocalS3Bootstrap.bootstrap(Mode.valueOf(args[0].toUpperCase(Locale.ROOT)), properties).start();
    }

    private static Properties loadProperties() {
        String[] names;
        Properties properties = new Properties();
        try (InputStream in = LocalS3Launcher.class.getClassLoader().getResourceAsStream("local-s3.properties");){
            if (in != null) {
                properties.load(in);
            }
        }
        for (String name : names = new String[]{"s3.port", "s3.executor.thread.num", "s3.data.directory", "s3.netty.parent.event.loop.group.thread", "s3.netty.child.event.loop.group.thread"}) {
            Object value = LocalS3Launcher.get(name);
            if (!Objects.nonNull(value)) continue;
            properties.put(name, value);
        }
        return properties;
    }

    private static Object get(String name) {
        String value = System.getProperty(name);
        if (null != value) {
            return value;
        }
        return System.getenv(name);
    }
}

