/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.bootstrap;

import com.robothy.netty.initializer.HttpServerInitializer;
import com.robothy.s3.rest.bootstrap.LocalS3Bootstrap;
import com.robothy.s3.rest.config.PersistLocalS3Options;
import com.robothy.s3.rest.handler.LocalS3RouterFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileSystemLocalS3Bootstrap
implements LocalS3Bootstrap {
    private static final Logger log = LoggerFactory.getLogger(FileSystemLocalS3Bootstrap.class);
    private final PersistLocalS3Options options;
    private NioEventLoopGroup parentGroup;
    private NioEventLoopGroup childGroup;
    private EventExecutorGroup executorGroup;
    private Channel serverSocketChannel;

    FileSystemLocalS3Bootstrap(Properties config) {
        this.options = this.buildOptions(config);
    }

    @Override
    public void start() {
        this.parentGroup = new NioEventLoopGroup(this.options.getNettyParentEventGroupThreadNum());
        this.childGroup = new NioEventLoopGroup(this.options.getNettyChildEventGroupThreadNum());
        this.executorGroup = new DefaultEventLoopGroup(this.options.getS3ExecutorThreadNum());
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ChannelFuture channelFuture = ((ServerBootstrap)((ServerBootstrap)serverBootstrap.group((EventLoopGroup)this.parentGroup, (EventLoopGroup)this.childGroup).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new HttpServerInitializer(this.executorGroup, LocalS3RouterFactory.create())).bind(this.options.getPort()).sync();
        this.serverSocketChannel = channelFuture.channel();
    }

    @Override
    public void shutdown() {
        if (null == this.parentGroup || null == this.childGroup) {
            throw new IllegalStateException("LocalS3 not started.");
        }
        try {
            this.serverSocketChannel.close().sync();
        }
        catch (InterruptedException e) {
            log.error("Close server socket channel failed.", (Throwable)e);
        }
        finally {
            this.executorGroup.shutdownGracefully();
            this.childGroup.shutdownGracefully();
            this.parentGroup.shutdownGracefully();
        }
    }

    private PersistLocalS3Options buildOptions(Properties config) {
        int port = Integer.parseInt(this.getProp(config, "s3.port", "80"));
        int parentThreadNum = Integer.parseInt(this.getProp(config, "s3.netty.parent.event.loop.group.thread", "0"));
        int childThreadNum = Integer.parseInt(this.getProp(config, "s3.netty.child.event.loop.group.thread", "0"));
        int executorThreadNum = Integer.parseInt(this.getProp(config, "s3.executor.thread.num", "5"));
        String rootDir = (String)config.getOrDefault((Object)"s3.data.directory", System.getProperty("user.home") + "/s3");
        log.info("s3.port: {}", (Object)port);
        log.info("s3.executor.thread.num: {}", (Object)executorThreadNum);
        log.info("s3.data.directory: {}", (Object)rootDir);
        return PersistLocalS3Options.builder().port(port).nettyParentEventGroupThreadNum(parentThreadNum).nettyChildEventGroupThreadNum(childThreadNum).s3ExecutorThreadNum(executorThreadNum).dataPath(rootDir).build();
    }

    private String getProp(Properties config, String name, String defaultValue) {
        String value;
        String string = value = config.containsKey(name) ? config.get(name).toString() : null;
        if (value == null) {
            value = config.getProperty(name);
        }
        return value == null ? defaultValue : value;
    }
}

