/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.model.Bucket;
import com.robothy.s3.core.service.BucketService;
import com.robothy.s3.datatypes.response.GetBucketResult;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.service.ServiceFactory;
import java.time.Instant;
import java.util.Date;

class GetBucketController
implements HttpRequestHandler {
    private final BucketService bucketService = ServiceFactory.getInstance(BucketService.class);
    private final XmlMapper xmlMapper = ServiceFactory.getInstance(XmlMapper.class);

    GetBucketController() {
    }

    public void handle(HttpRequest request, HttpResponse response) throws Exception {
        String bucketName = RequestAssertions.assertBucketNameProvided(request);
        Bucket bucket = this.bucketService.getBucket(bucketName);
        GetBucketResult getBucketResult = GetBucketResult.builder().bucket(bucket.getName()).creationDate(Date.from(Instant.ofEpochMilli(bucket.getCreationDate()))).publicAccessBlockEnabled(false).build();
        response.write(this.xmlMapper.writeValueAsString((Object)getBucketResult));
    }
}

