/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class AwsUnsignedChunkedDecodingInputStream
extends InputStream {
    private static final byte[] CRLF = "\r\n".getBytes(StandardCharsets.UTF_8);
    private final InputStream source;
    private int remainingInChunk;

    public AwsUnsignedChunkedDecodingInputStream(InputStream source) {
        this.source = source;
    }

    @Override
    public int read() throws IOException {
        if (this.remainingInChunk == 0) {
            String chunkSizeHex = this.readLine();
            while (chunkSizeHex != null && chunkSizeHex.trim().isEmpty()) {
                chunkSizeHex = this.readLine();
            }
            if (chunkSizeHex == null) {
                return -1;
            }
            this.remainingInChunk = Integer.parseInt(chunkSizeHex.trim(), 16);
            if (this.remainingInChunk == 0) {
                this.readLine();
                return -1;
            }
        }
        --this.remainingInChunk;
        return this.source.read();
    }

    private String readLine() throws IOException {
        int cur;
        StringBuilder sb = new StringBuilder();
        int prev = -1;
        while ((cur = this.source.read()) != -1) {
            if (prev == 13 && cur == 10) {
                sb.setLength(sb.length() - 1);
                break;
            }
            sb.append((char)cur);
            prev = cur;
        }
        if (sb.length() == 0 && cur == -1) {
            return null;
        }
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }
}

