/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest;

import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.robothy.netty.initializer.HttpServerInitializer;
import com.robothy.s3.core.service.BucketService;
import com.robothy.s3.core.service.ObjectService;
import com.robothy.s3.core.service.manager.LocalS3Manager;
import com.robothy.s3.rest.bootstrap.LocalS3Mode;
import com.robothy.s3.rest.handler.LocalS3RouterFactory;
import com.robothy.s3.rest.service.DefaultServiceFactory;
import com.robothy.s3.rest.service.ServiceFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.ServerSocket;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ThreadFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalS3 {
    private static final Logger log = LoggerFactory.getLogger(LocalS3.class);
    private int port = 8080;
    private Path dataPath;
    private LocalS3Mode mode = LocalS3Mode.IN_MEMORY;
    private boolean initialDataCacheEnabled = true;
    private int nettyParentEventGroupThreadNum = 1;
    private int nettyChildEventGroupThreadNum = 2;
    private int s3ExecutorThreadNum = 4;
    private NioEventLoopGroup parentGroup;
    private NioEventLoopGroup childGroup;
    private EventExecutorGroup executorGroup;
    private Channel serverSocketChannel;

    public static Builder builder() {
        return new Builder();
    }

    public void start() {
        ServiceFactory serviceFactory = this.createServiceFactory();
        this.parentGroup = new NioEventLoopGroup(this.nettyParentEventGroupThreadNum, (ThreadFactory)new NamingThreadFactory("locals3-parent-event-group"));
        this.childGroup = new NioEventLoopGroup(this.nettyChildEventGroupThreadNum, (ThreadFactory)new NamingThreadFactory("locals3-child-event-group"));
        this.executorGroup = new DefaultEventLoopGroup(this.s3ExecutorThreadNum, (ThreadFactory)new NamingThreadFactory("locals3-executor-group"));
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ChannelFuture channelFuture = null;
        try {
            channelFuture = ((ServerBootstrap)((ServerBootstrap)serverBootstrap.group((EventLoopGroup)this.parentGroup, (EventLoopGroup)this.childGroup).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new HttpServerInitializer(this.executorGroup, LocalS3RouterFactory.create(serviceFactory))).bind(this.port).sync();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        log.info("LocalS3 started.");
        this.serverSocketChannel = channelFuture.channel();
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    private ServiceFactory createServiceFactory() {
        LocalS3Manager manager;
        if (this.mode == LocalS3Mode.IN_MEMORY) {
            log.info("Created in-memory LocalS3 manager.");
            manager = LocalS3Manager.createInMemoryS3Manager((Path)this.dataPath, (boolean)this.initialDataCacheEnabled);
        } else {
            log.info("Created file system LocalS3 manager.");
            manager = LocalS3Manager.createFileSystemS3Manager((Path)this.dataPath);
        }
        DefaultServiceFactory serviceFactory = new DefaultServiceFactory();
        BucketService bucketService = manager.bucketService();
        ObjectService objectService = manager.objectService();
        serviceFactory.register(BucketService.class, () -> bucketService);
        serviceFactory.register(ObjectService.class, () -> objectService);
        WstxInputFactory input = new WstxInputFactory();
        input.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        input.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        input.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        XmlMapper xmlMapper = new XmlMapper(new XmlFactory((XMLInputFactory)input, (XMLOutputFactory)new WstxOutputFactory()));
        xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        xmlMapper.registerModule((Module)new Jdk8Module());
        xmlMapper.registerModule((Module)new JavaTimeModule());
        serviceFactory.register(XmlMapper.class, () -> xmlMapper);
        return serviceFactory;
    }

    public void shutdown() {
        block5: {
            if (null == this.parentGroup || null == this.childGroup) {
                throw new IllegalStateException("LocalS3 is not started.");
            }
            try {
                if (!this.serverSocketChannel.isOpen()) break block5;
                this.serverSocketChannel.close().sync();
            }
            catch (InterruptedException e) {
                try {
                    log.error("Close server socket channel failed.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.shutdownEventExecutorsGroupIfNeeded(new EventExecutorGroup[]{this.childGroup, this.parentGroup, this.executorGroup});
                    throw throwable;
                }
                this.shutdownEventExecutorsGroupIfNeeded(new EventExecutorGroup[]{this.childGroup, this.parentGroup, this.executorGroup});
            }
        }
        this.shutdownEventExecutorsGroupIfNeeded(new EventExecutorGroup[]{this.childGroup, this.parentGroup, this.executorGroup});
    }

    private void shutdownEventExecutorsGroupIfNeeded(EventExecutorGroup ... eventExecutorsList) {
        boolean shutdownPerformed = false;
        for (EventExecutorGroup eventExecutors : eventExecutorsList) {
            if (eventExecutors.isShuttingDown() || eventExecutors.isShutdown()) continue;
            shutdownPerformed = true;
            eventExecutors.shutdownGracefully();
        }
        if (shutdownPerformed) {
            log.info("LocalS3 stopped.");
        }
    }

    public int getPort() {
        return this.port;
    }

    public Path getDataPath() {
        return this.dataPath;
    }

    public static class Builder {
        private final LocalS3 propHolder = new LocalS3();

        public Builder port(int port) {
            if (port < 0) {
                this.propHolder.port = this.findFreeTcpPort();
            } else {
                this.propHolder.port = port;
            }
            return this;
        }

        public Builder dataPath(String dataPath) {
            this.propHolder.dataPath = dataPath == null ? null : Paths.get(dataPath, new String[0]);
            return this;
        }

        public Builder mode(LocalS3Mode mode) {
            this.propHolder.mode = mode;
            return this;
        }

        public Builder initialDataCacheEnabled(boolean enabled) {
            this.propHolder.initialDataCacheEnabled = enabled;
            return this;
        }

        public Builder nettyParentEventGroupThreadNum(int nettyParentEventGroupThreadNum) {
            this.propHolder.nettyParentEventGroupThreadNum = nettyParentEventGroupThreadNum;
            return this;
        }

        public Builder nettyChildEventGroupThreadNum(int nettyChildEventGroupThreadNum) {
            this.propHolder.nettyChildEventGroupThreadNum = nettyChildEventGroupThreadNum;
            return this;
        }

        public Builder s3ExecutorThreadNum(int s3ExecutorThreadNum) {
            this.propHolder.s3ExecutorThreadNum = s3ExecutorThreadNum;
            return this;
        }

        public LocalS3 build() {
            LocalS3 localS3 = new LocalS3();
            for (Field field : FieldUtils.getAllFields(LocalS3.class)) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
                try {
                    field.setAccessible(true);
                    Object value = FieldUtils.readField((Field)field, (Object)this.propHolder);
                    FieldUtils.writeField((Field)field, (Object)localS3, (Object)value);
                    log.debug(field.getName() + ": " + value);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
            return localS3;
        }

        private int findFreeTcpPort() {
            int freePort;
            try (ServerSocket serverSocket = new ServerSocket(0);){
                freePort = serverSocket.getLocalPort();
            }
            catch (IOException e) {
                throw new IllegalStateException("TCP port is not available.");
            }
            return freePort;
        }
    }

    private static final class NamingThreadFactory
    implements ThreadFactory {
        private final String name;
        private int counter = 0;

        public NamingThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.name + "-" + this.counter++);
        }
    }
}

