/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.exception.LocalS3InvalidArgumentException;
import com.robothy.s3.core.model.answers.CopyObjectAns;
import com.robothy.s3.core.model.request.CopyObjectOptions;
import com.robothy.s3.core.service.CopyObjectService;
import com.robothy.s3.core.service.ObjectService;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.model.response.CopyObjectResult;
import com.robothy.s3.rest.service.ServiceFactory;
import com.robothy.s3.rest.utils.ResponseUtils;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

class CopyObjectController
implements HttpRequestHandler {
    private final CopyObjectService objectService;
    private final XmlMapper xmlMapper;

    CopyObjectController(ServiceFactory serviceFactory) {
        this.objectService = (CopyObjectService)serviceFactory.getInstance(ObjectService.class);
        this.xmlMapper = serviceFactory.getInstance(XmlMapper.class);
    }

    public void handle(HttpRequest request, HttpResponse response) throws Exception {
        String destinationBucket = RequestAssertions.assertBucketNameProvided(request);
        String destinationKey = RequestAssertions.assertObjectKeyProvided(request);
        CopyObjectOptions copyObjectOptions = this.parseCopyOptions(request);
        CopyObjectAns copyObjectAns = this.objectService.copyObject(destinationBucket, destinationKey, copyObjectOptions);
        CopyObjectResult result = CopyObjectResult.builder().lastModified(Instant.ofEpochMilli(copyObjectAns.getLastModified())).etag(copyObjectAns.getEtag()).build();
        response.status(HttpResponseStatus.OK).write(this.xmlMapper.writeValueAsString((Object)result)).putHeader(HttpHeaderNames.CONTENT_TYPE.toString(), (Object)HttpHeaderValues.APPLICATION_XML).putHeader("x-amz-version-id", (Object)copyObjectAns.getVersionId()).putHeader("x-amz-copy-source-version-id", (Object)copyObjectAns.getSourceVersionId());
        ResponseUtils.addAmzRequestId(response);
        ResponseUtils.addDateHeader(response);
        ResponseUtils.addServerHeader(response);
    }

    CopyObjectOptions parseCopyOptions(HttpRequest request) {
        String copySource = this.extractCopySourceHeader(request);
        SourceObjectInfo sourceInfo = this.parseCopySourcePath(copySource);
        CopyObjectOptions.MetadataDirective metadataDirective = this.parseMetadataDirective(request);
        Map<String, String> userMetadata = this.extractUserMetadata(request, metadataDirective);
        return CopyObjectOptions.builder().sourceBucket(this.urlDecode(sourceInfo.bucket)).sourceKey(this.urlDecode(sourceInfo.key)).sourceVersion(this.urlDecode(sourceInfo.versionId)).metadataDirective(metadataDirective).userMetadata(userMetadata).build();
    }

    private String extractCopySourceHeader(HttpRequest request) {
        return (String)request.header((CharSequence)"x-amz-copy-source").orElseThrow(() -> new IllegalArgumentException("x-amz-copy-source header is required."));
    }

    private SourceObjectInfo parseCopySourcePath(String copySource) {
        String[] slices = copySource.split("\\?");
        String path = slices[0];
        int delimiterIndex = path.indexOf(47, 1);
        if (-1 == delimiterIndex || delimiterIndex == path.length() - 1) {
            throw new LocalS3InvalidArgumentException("x-amz-copy-source", copySource, "Invalid copy source.");
        }
        String srcBucket = path.charAt(0) == '/' ? path.substring(1, delimiterIndex) : path.substring(0, delimiterIndex);
        String srcKey = path.charAt(path.length() - 1) == '/' ? path.substring(delimiterIndex + 1, path.length() - 1) : path.substring(delimiterIndex + 1);
        String srcVersionId = this.extractVersionId(slices);
        return new SourceObjectInfo(srcBucket, srcKey, srcVersionId);
    }

    private String extractVersionId(String[] pathSlices) {
        if (pathSlices.length <= 1) {
            return null;
        }
        String queryParams = pathSlices[1];
        String[] pairs = queryParams.split("\\&");
        return Stream.of(pairs).filter(pair -> pair.startsWith("versionId") && pair.contains("=")).map(pair -> pair.split("=")[1]).findAny().orElse(null);
    }

    private CopyObjectOptions.MetadataDirective parseMetadataDirective(HttpRequest request) {
        String metadataDirectiveHeader = request.header((CharSequence)"x-amz-metadata-directive").orElse(null);
        if (metadataDirectiveHeader == null) {
            return CopyObjectOptions.MetadataDirective.COPY;
        }
        try {
            return CopyObjectOptions.MetadataDirective.valueOf((String)metadataDirectiveHeader);
        }
        catch (IllegalArgumentException e) {
            throw new LocalS3InvalidArgumentException("x-amz-metadata-directive", metadataDirectiveHeader, "Invalid metadata directive.");
        }
    }

    private Map<String, String> extractUserMetadata(HttpRequest request, CopyObjectOptions.MetadataDirective metadataDirective) {
        if (metadataDirective != CopyObjectOptions.MetadataDirective.REPLACE) {
            return Collections.emptyMap();
        }
        HashMap<String, String> userMetadata = new HashMap<String, String>();
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            String name = ((CharSequence)entry.getKey()).toString();
            String value = (String)entry.getValue();
            if (name == null || !name.startsWith("x-amz-meta-")) continue;
            String key = name.substring("x-amz-meta-".length());
            userMetadata.put(key, value);
        }
        return userMetadata;
    }

    private String urlDecode(String value) {
        try {
            if (Objects.isNull(value)) {
                return null;
            }
            return URLDecoder.decode(value, StandardCharsets.UTF_8.displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class SourceObjectInfo {
        private final String bucket;
        private final String key;
        private final String versionId;

        public SourceObjectInfo(String bucket, String key, String versionId) {
            this.bucket = bucket;
            this.key = key;
            this.versionId = versionId;
        }
    }
}

