/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.exception.BucketNotExistException;
import com.robothy.s3.core.service.BucketService;
import com.robothy.s3.datatypes.PolicyStatus;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.service.ServiceFactory;
import com.robothy.s3.rest.utils.ResponseUtils;
import io.netty.handler.codec.http.HttpResponseStatus;

class GetBucketPolicyStatusController
implements HttpRequestHandler {
    private final BucketService bucketService;
    private final XmlMapper xmlMapper;

    GetBucketPolicyStatusController(ServiceFactory serviceFactory) {
        this.bucketService = serviceFactory.getInstance(BucketService.class);
        this.xmlMapper = serviceFactory.getInstance(XmlMapper.class);
    }

    public void handle(HttpRequest request, HttpResponse response) throws Exception {
        PolicyStatus policyStatus;
        String bucketName = RequestAssertions.assertBucketNameProvided(request);
        try {
            policyStatus = this.bucketService.getBucketPolicyStatus(bucketName);
        }
        catch (BucketNotExistException e) {
            response.status(HttpResponseStatus.NOT_FOUND);
            return;
        }
        response.write(this.xmlMapper.writeValueAsString((Object)policyStatus));
        ResponseUtils.addCommonHeaders(response);
    }
}

