/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.router.AbstractRouter;
import com.robothy.netty.router.Route;
import com.robothy.netty.router.Router;
import com.robothy.s3.rest.model.request.BucketRegion;
import com.robothy.s3.rest.utils.VirtualHostParser;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

class LocalS3Router
extends AbstractRouter {
    static final String BUCKET_PATH = "/{bucket}";
    static final String BUCKET_KEY_PATH = "/{bucket}/{key}";
    private final Map<HttpMethod, Map<String, List<Route>>> rules = new HashMap<HttpMethod, Map<String, List<Route>>>();

    LocalS3Router() {
    }

    public Router route(Route rule) {
        this.rules.putIfAbsent(rule.getMethod(), new HashMap());
        Map<String, List<Route>> pathRules = this.rules.get(rule.getMethod());
        pathRules.putIfAbsent(rule.getPath(), new ArrayList());
        List<Route> routes = pathRules.get(rule.getPath());
        routes.add(rule);
        return this;
    }

    public HttpRequestHandler match(HttpRequest request) {
        return this.matchMethod(request.getMethod()).map(pathRules -> this.matchPath((Map<String, List<Route>>)pathRules, request)).map(rules -> this.matchHandler((List<Route>)rules, request)).orElse(this.notFoundHandler());
    }

    Optional<Map<String, List<Route>>> matchMethod(HttpMethod method) {
        return Optional.ofNullable(this.rules.get(method));
    }

    List<Route> matchPath(Map<String, List<Route>> pathRules, HttpRequest request) {
        String bucketName;
        String path = request.getPath();
        String trimmedPath = this.trimPath(path);
        if (pathRules.containsKey(trimmedPath)) {
            return pathRules.get(trimmedPath);
        }
        Map params = request.getParams();
        Optional<BucketRegion> bucketRegion = VirtualHostParser.getBucketRegionFromHost((String)request.getHeaders().get(HttpHeaderNames.HOST.toString()));
        boolean bucketNameInPath = !bucketRegion.isPresent() || !bucketRegion.get().getBucketName().isPresent();
        String objectKey = null;
        if (bucketNameInPath) {
            int slashCount = StringUtils.countMatches((CharSequence)path, (char)'/');
            if (slashCount == 1 || slashCount == 2 && path.endsWith("/")) {
                bucketName = trimmedPath.substring(1);
            } else {
                int secondSlashIdx = path.indexOf(47, 1);
                bucketName = path.substring(1, secondSlashIdx);
                objectKey = path.substring(secondSlashIdx + 1);
            }
        } else {
            bucketName = bucketRegion.get().getBucketName().get();
            if (!"/".equals(trimmedPath)) {
                objectKey = path.substring(1);
            }
        }
        this.setBucketNameAndObjectKeyToRequestParams(params, bucketName, objectKey);
        boolean isBucketOperation = Objects.isNull(objectKey);
        return this.getCandidateHandlers(pathRules, isBucketOperation);
    }

    String trimPath(String path) {
        if ("/".equals(path)) {
            return path;
        }
        if ((path = path.trim()).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    void setBucketNameAndObjectKeyToRequestParams(Map<CharSequence, List<String>> params, String bucketName, String objectKey) {
        params.put("bucket", List.of(bucketName));
        if (Objects.nonNull(objectKey)) {
            params.put("key", List.of(objectKey));
        }
    }

    List<Route> getCandidateHandlers(Map<String, List<Route>> pathRules, boolean bucketOperation) {
        if (bucketOperation) {
            return pathRules.get(BUCKET_PATH);
        }
        return pathRules.get(BUCKET_KEY_PATH);
    }

    HttpRequestHandler matchHandler(List<Route> candidates, HttpRequest request) {
        HttpRequestHandler result = null;
        int priority = 0;
        for (Route candidate : candidates) {
            int currentPriority = this.calculatePriority(candidate, request);
            if (currentPriority < priority) continue;
            priority = currentPriority;
            result = candidate.getHandler();
        }
        return result;
    }

    int calculatePriority(Route route, HttpRequest request) {
        int priority = 0;
        priority = Objects.isNull(route.getHeaderMatcher()) ? (priority |= 2) : (((Boolean)route.getHeaderMatcher().apply(request.getHeaders())).booleanValue() ? (priority |= 8) : -1);
        priority = Objects.isNull(route.getParamMatcher()) ? (priority |= 4) : (((Boolean)route.getParamMatcher().apply(request.getParams())).booleanValue() ? (priority |= 0x10) : -1);
        return priority;
    }
}

