/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.service.BucketAclService;
import com.robothy.s3.core.service.BucketService;
import com.robothy.s3.datatypes.AccessControlPolicy;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.service.ServiceFactory;
import com.robothy.s3.rest.utils.ResponseUtils;
import io.netty.buffer.ByteBufInputStream;
import java.io.InputStream;
import java.util.Optional;

class PutBucketAclController
implements HttpRequestHandler {
    private final BucketAclService aclService;
    private final XmlMapper xmlMapper;

    PutBucketAclController(ServiceFactory serviceFactory) {
        this.aclService = (BucketAclService)serviceFactory.getInstance(BucketService.class);
        this.xmlMapper = serviceFactory.getInstance(XmlMapper.class);
    }

    public void handle(HttpRequest request, HttpResponse response) throws Exception {
        String bucketName = RequestAssertions.assertBucketNameProvided(request);
        try (ByteBufInputStream in = new ByteBufInputStream(request.getBody());){
            AccessControlPolicy acl = this.getAclFromHeader(request).orElse((AccessControlPolicy)this.xmlMapper.readValue((InputStream)in, AccessControlPolicy.class));
            this.aclService.putBucketAcl(bucketName, acl);
        }
        ResponseUtils.addDateHeader(response);
        ResponseUtils.addServerHeader(response);
        ResponseUtils.addAmzRequestId(response);
    }

    private Optional<AccessControlPolicy> getAclFromHeader(HttpRequest request) {
        return Optional.empty();
    }
}

