/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.utils;

import com.robothy.s3.rest.model.request.BucketRegion;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class VirtualHostParser {
    static final String AWS_DOMAIN = ".amazonaws.com";
    static final Set<String> LOCAL_DOMAINS = Set.of(".localhost", ".127.0.0.1", ".0.0.0.0");

    public static Optional<BucketRegion> getBucketRegionFromHost(String host) {
        if (StringUtils.isBlank((CharSequence)host)) {
            return Optional.empty();
        }
        if ((host = VirtualHostParser.removePortIfExist(host.trim())).endsWith(AWS_DOMAIN)) {
            return VirtualHostParser.parseHostUnderAwsDomain(host);
        }
        Optional<String> localDomainOpt = LOCAL_DOMAINS.stream().filter(host::endsWith).map(domainWithDotPrefix -> domainWithDotPrefix.substring(1)).findFirst();
        if (!localDomainOpt.isPresent()) {
            return Optional.empty();
        }
        String finalHost = host;
        return LOCAL_DOMAINS.stream().filter(host::endsWith).findFirst().flatMap(localDomainPrependDot -> VirtualHostParser.parseHostFromLocalDomain(finalHost, localDomainPrependDot));
    }

    static Optional<BucketRegion> parseHostUnderAwsDomain(String host) {
        String domain = AWS_DOMAIN.substring(1);
        if (VirtualHostParser.isLegacyGlobalEndpoint(host, domain)) {
            return VirtualHostParser.parseLegacyEndpoint(host, domain);
        }
        String hostWithoutDomain = host.substring(0, host.length() - domain.length() - 1);
        Optional<String> regionOpt = VirtualHostParser.getRegion(hostWithoutDomain);
        if (!regionOpt.isPresent()) {
            return Optional.empty();
        }
        String region = regionOpt.get();
        String s3RegionDomain = ".s3." + region + "." + domain;
        if (s3RegionDomain.equals("." + host)) {
            return Optional.of(new BucketRegion(region, null));
        }
        String bucketName = host.substring(0, host.length() - s3RegionDomain.length());
        return Optional.of(new BucketRegion(region, bucketName));
    }

    private static Optional<BucketRegion> parseLegacyEndpoint(String host, String domain) {
        int bucketNameLength = host.length() - ".s3.".length() - domain.length();
        if (bucketNameLength > 0) {
            return Optional.of(new BucketRegion("local", host.substring(0, bucketNameLength)));
        }
        return Optional.empty();
    }

    static Optional<String> getRegion(String hostWithoutDomain) {
        if (hostWithoutDomain.startsWith("s3.")) {
            return Optional.of(hostWithoutDomain.substring(3));
        }
        int regionDelimiterIdx = hostWithoutDomain.lastIndexOf(".s3.");
        if (regionDelimiterIdx <= 0) {
            return Optional.empty();
        }
        return Optional.of(hostWithoutDomain.substring(regionDelimiterIdx + ".s3.".length()));
    }

    static boolean isLegacyGlobalEndpoint(String hostWithDomain, String domain) {
        String s3WithDomain = ".s3." + domain;
        return hostWithDomain.endsWith(s3WithDomain);
    }

    static String removePortIfExist(String host) {
        int colonIdx = host.lastIndexOf(58);
        if (colonIdx > 0) {
            return host.substring(0, colonIdx);
        }
        return host;
    }

    static Optional<BucketRegion> parseHostFromLocalDomain(String host, String localDomainPrependDot) {
        if (localDomainPrependDot.endsWith(host)) {
            return Optional.empty();
        }
        return Optional.of(new BucketRegion("local", host.substring(0, host.length() - localDomainPrependDot.length())));
    }
}

