/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.config;

import java.io.InputStream;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public class Configs {
    private static final Properties properties = new Properties();

    public static String get(String name) {
        String property = Configs.get0(name);
        if (StringUtils.isBlank((CharSequence)property)) {
            throw new IllegalArgumentException("Cannot find property '" + name + "'.");
        }
        return property;
    }

    public static String get(String name, String defaultValue) {
        String property = Configs.get0(name);
        if (StringUtils.isBlank((CharSequence)property)) {
            return defaultValue;
        }
        return property;
    }

    private static String get0(String name) {
        Supplier supplier;
        Supplier[] suppliers = new Supplier[]{() -> System.getProperty(name), () -> System.getenv(name), () -> properties.containsKey(name) ? properties.get(name).toString() : null};
        String property = null;
        Supplier[] supplierArray = suppliers;
        int n = supplierArray.length;
        for (int i = 0; i < n && !StringUtils.isNotBlank((CharSequence)(property = (String)(supplier = supplierArray[i]).get())); ++i) {
        }
        return property;
    }

    private static void loadProperties() {
        block8: {
            InputStream in = Configs.class.getClassLoader().getResourceAsStream("local-s3.properties");
            if (in == null) break block8;
            try (InputStream inputStream = in;){
                properties.load(in);
            }
        }
    }

    static {
        Configs.loadProperties();
    }
}

