/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.config;

public class PersistLocalS3Options {
    private int port;
    private String dataPath;
    private int nettyParentEventGroupThreadNum;
    private int nettyChildEventGroupThreadNum;
    private int s3ExecutorThreadNum;

    PersistLocalS3Options(int port, String dataPath, int nettyParentEventGroupThreadNum, int nettyChildEventGroupThreadNum, int s3ExecutorThreadNum) {
        this.port = port;
        this.dataPath = dataPath;
        this.nettyParentEventGroupThreadNum = nettyParentEventGroupThreadNum;
        this.nettyChildEventGroupThreadNum = nettyChildEventGroupThreadNum;
        this.s3ExecutorThreadNum = s3ExecutorThreadNum;
    }

    public static PersistLocalS3OptionsBuilder builder() {
        return new PersistLocalS3OptionsBuilder();
    }

    public int getPort() {
        return this.port;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public int getNettyParentEventGroupThreadNum() {
        return this.nettyParentEventGroupThreadNum;
    }

    public int getNettyChildEventGroupThreadNum() {
        return this.nettyChildEventGroupThreadNum;
    }

    public int getS3ExecutorThreadNum() {
        return this.s3ExecutorThreadNum;
    }

    public static class PersistLocalS3OptionsBuilder {
        private int port;
        private String dataPath;
        private int nettyParentEventGroupThreadNum;
        private int nettyChildEventGroupThreadNum;
        private int s3ExecutorThreadNum;

        PersistLocalS3OptionsBuilder() {
        }

        public PersistLocalS3OptionsBuilder port(int port) {
            this.port = port;
            return this;
        }

        public PersistLocalS3OptionsBuilder dataPath(String dataPath) {
            this.dataPath = dataPath;
            return this;
        }

        public PersistLocalS3OptionsBuilder nettyParentEventGroupThreadNum(int nettyParentEventGroupThreadNum) {
            this.nettyParentEventGroupThreadNum = nettyParentEventGroupThreadNum;
            return this;
        }

        public PersistLocalS3OptionsBuilder nettyChildEventGroupThreadNum(int nettyChildEventGroupThreadNum) {
            this.nettyChildEventGroupThreadNum = nettyChildEventGroupThreadNum;
            return this;
        }

        public PersistLocalS3OptionsBuilder s3ExecutorThreadNum(int s3ExecutorThreadNum) {
            this.s3ExecutorThreadNum = s3ExecutorThreadNum;
            return this;
        }

        public PersistLocalS3Options build() {
            return new PersistLocalS3Options(this.port, this.dataPath, this.nettyParentEventGroupThreadNum, this.nettyChildEventGroupThreadNum, this.s3ExecutorThreadNum);
        }

        public String toString() {
            return "PersistLocalS3Options.PersistLocalS3OptionsBuilder(port=" + this.port + ", dataPath=" + this.dataPath + ", nettyParentEventGroupThreadNum=" + this.nettyParentEventGroupThreadNum + ", nettyChildEventGroupThreadNum=" + this.nettyChildEventGroupThreadNum + ", s3ExecutorThreadNum=" + this.s3ExecutorThreadNum + ")";
        }
    }
}

