/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.model.answers.DeleteObjectAns;
import com.robothy.s3.core.service.DeleteObjectService;
import com.robothy.s3.core.service.ObjectService;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.service.ServiceFactory;
import com.robothy.s3.rest.utils.ResponseUtils;
import io.netty.handler.codec.http.HttpResponseStatus;

class DeleteObjectController
implements HttpRequestHandler {
    private final DeleteObjectService deleteObjectService = (DeleteObjectService)ServiceFactory.getInstance(ObjectService.class);

    DeleteObjectController() {
    }

    public void handle(HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
        String bucketName = RequestAssertions.assertBucketNameProvided(httpRequest);
        String key = RequestAssertions.assertObjectKeyProvided(httpRequest);
        String versionId = httpRequest.parameter("versionId").orElse(null);
        DeleteObjectAns deleteObjectAns = this.deleteObjectService.deleteObject(bucketName, key, versionId);
        httpResponse.status(HttpResponseStatus.NO_CONTENT).putHeader("x-amz-delete-marker", (Object)deleteObjectAns.isDeleteMarker()).putHeader("x-amz-version-id", (Object)deleteObjectAns.getVersionId());
        ResponseUtils.addAmzRequestId(httpResponse);
        ResponseUtils.addDateHeader(httpResponse);
        ResponseUtils.addServerHeader(httpResponse);
    }
}

