/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.router.Route;
import com.robothy.netty.router.Router;
import com.robothy.s3.core.exception.LocalS3Exception;
import com.robothy.s3.rest.handler.BucketPolicyController;
import com.robothy.s3.rest.handler.CompleteMultipartUploadController;
import com.robothy.s3.rest.handler.CopyObjectController;
import com.robothy.s3.rest.handler.CreateBucketController;
import com.robothy.s3.rest.handler.CreateMultipartUploadController;
import com.robothy.s3.rest.handler.DeleteBucketController;
import com.robothy.s3.rest.handler.DeleteBucketTaggingController;
import com.robothy.s3.rest.handler.DeleteObjectController;
import com.robothy.s3.rest.handler.ExceptionHandler;
import com.robothy.s3.rest.handler.GetBucketAclController;
import com.robothy.s3.rest.handler.GetBucketController;
import com.robothy.s3.rest.handler.GetBucketTaggingController;
import com.robothy.s3.rest.handler.GetBucketVersioningController;
import com.robothy.s3.rest.handler.GetObjectController;
import com.robothy.s3.rest.handler.HeadBucketController;
import com.robothy.s3.rest.handler.HeadObjectController;
import com.robothy.s3.rest.handler.IllegalArgumentExceptionHandler;
import com.robothy.s3.rest.handler.ListObjectVersionsController;
import com.robothy.s3.rest.handler.ListObjectsController;
import com.robothy.s3.rest.handler.LocalS3ExceptionHandler;
import com.robothy.s3.rest.handler.NotFoundHandler;
import com.robothy.s3.rest.handler.PutBucketAclController;
import com.robothy.s3.rest.handler.PutBucketTaggingController;
import com.robothy.s3.rest.handler.PutBucketVersioningController;
import com.robothy.s3.rest.handler.PutObjectController;
import com.robothy.s3.rest.handler.UploadPartController;
import io.netty.handler.codec.http.HttpMethod;

public class LocalS3RouterFactory {
    private final BucketPolicyController bucketPolicy = new BucketPolicyController();
    private final Route CopyObject = Route.builder().method(HttpMethod.PUT).path("/{bucket}/{*key}").headerMatcher(headers -> headers.containsKey("x-amz-copy-source")).handler((HttpRequestHandler)new CopyObjectController()).build();
    private final Route CreateBucket = Route.builder().method(HttpMethod.PUT).path("/{bucket}").handler((HttpRequestHandler)new CreateBucketController()).build();
    private final Route CreateMultipartUpload = Route.builder().method(HttpMethod.POST).path("/{bucket}/{*key}").paramMatcher(params -> params.containsKey("uploads")).handler((HttpRequestHandler)new CreateMultipartUploadController()).build();
    private final Route CompleteMultipartUpload = Route.builder().method(HttpMethod.POST).path("/{bucket}/{*key}").handler((HttpRequestHandler)new CompleteMultipartUploadController()).build();
    private final Route DeleteBucket = Route.builder().method(HttpMethod.DELETE).path("/{bucket}").handler((HttpRequestHandler)new DeleteBucketController()).build();
    private final Route DeleteBucketPolicy = Route.builder().method(HttpMethod.DELETE).path("/{bucket}").paramMatcher(params -> params.containsKey("policy")).handler(this.bucketPolicy::delete).build();
    private final Route DeleteBucketPolicy_ = Route.builder().method(HttpMethod.DELETE).path("/{bucket}/").paramMatcher(params -> params.containsKey("policy")).handler(this.bucketPolicy::delete).build();
    private final Route DeleteBucketTagging = Route.builder().method(HttpMethod.DELETE).path("/{bucket}").paramMatcher(params -> params.containsKey("tagging")).handler((HttpRequestHandler)new DeleteBucketTaggingController()).build();
    private final Route DeleteBucketTagging_ = Route.builder().method(HttpMethod.DELETE).path("/{bucket}/").paramMatcher(params -> params.containsKey("tagging")).handler((HttpRequestHandler)new DeleteBucketTaggingController()).build();
    private final Route DeleteObject = Route.builder().method(HttpMethod.DELETE).path("/{bucket}/{*key}").handler((HttpRequestHandler)new DeleteObjectController()).build();
    private final Route GetBucket = Route.builder().method(HttpMethod.GET).path("/v20180820/bucket/{bucket}").handler((HttpRequestHandler)new GetBucketController()).build();
    private final Route GetBucketAcl = Route.builder().method(HttpMethod.GET).path("/{bucket}").paramMatcher(params -> params.containsKey("acl")).handler((HttpRequestHandler)new GetBucketAclController()).build();
    private final Route GetBucketAcl_ = Route.builder().method(HttpMethod.GET).path("/{bucket}/").paramMatcher(params -> params.containsKey("acl")).handler((HttpRequestHandler)new GetBucketAclController()).build();
    private final Route GetBucketPolicy = Route.builder().method(HttpMethod.GET).path("/{bucket}").paramMatcher(params -> params.containsKey("policy")).handler(this.bucketPolicy::get).build();
    private final Route GetBucketPolicy_ = Route.builder().method(HttpMethod.GET).path("/{bucket}/").paramMatcher(params -> params.containsKey("policy")).handler(this.bucketPolicy::get).build();
    private final Route GetBucketVersioning = Route.builder().method(HttpMethod.GET).path("/{bucket}").paramMatcher(params -> params.containsKey("versioning")).handler((HttpRequestHandler)new GetBucketVersioningController()).build();
    private final Route GetBucketVersioning_ = Route.builder().method(HttpMethod.GET).path("/{bucket}/").paramMatcher(params -> params.containsKey("versioning")).handler((HttpRequestHandler)new GetBucketVersioningController()).build();
    private final Route GetBucketTagging = Route.builder().method(HttpMethod.GET).path("/{bucket}").paramMatcher(params -> params.containsKey("tagging")).handler((HttpRequestHandler)new GetBucketTaggingController()).build();
    private final Route GetBucketTagging_ = Route.builder().method(HttpMethod.GET).path("/{bucket}/").paramMatcher(params -> params.containsKey("tagging")).handler((HttpRequestHandler)new GetBucketTaggingController()).build();
    private final Route GetObject = Route.builder().method(HttpMethod.GET).path("/{bucket}/{*key}").handler((HttpRequestHandler)new GetObjectController()).build();
    private final Route HeadBucket = Route.builder().method(HttpMethod.HEAD).path("/{bucket}").handler((HttpRequestHandler)new HeadBucketController()).build();
    private final Route HeadObject = Route.builder().method(HttpMethod.HEAD).path("/{bucket}/{*key}").handler((HttpRequestHandler)new HeadObjectController()).build();
    private final Route ListObjects = Route.builder().method(HttpMethod.GET).path("/{bucket}").handler((HttpRequestHandler)new ListObjectsController()).build();
    private final Route ListObjects_ = Route.builder().method(HttpMethod.GET).path("/{bucket}/").handler((HttpRequestHandler)new ListObjectsController()).build();
    private final Route ListObjectVersions = Route.builder().method(HttpMethod.GET).path("/{bucket}").paramMatcher(params -> params.containsKey("versions")).handler((HttpRequestHandler)new ListObjectVersionsController()).build();
    private final Route ListObjectVersions_ = Route.builder().method(HttpMethod.GET).path("/{bucket}/").paramMatcher(params -> params.containsKey("versions")).handler((HttpRequestHandler)new ListObjectVersionsController()).build();
    private final Route PutBucketAcl = Route.builder().method(HttpMethod.PUT).path("/{bucket}").paramMatcher(params -> params.containsKey("acl")).handler((HttpRequestHandler)new PutBucketAclController()).build();
    private final Route PutBucketAcl_ = Route.builder().method(HttpMethod.PUT).path("/{bucket}/").paramMatcher(params -> params.containsKey("acl")).handler((HttpRequestHandler)new PutBucketAclController()).build();
    private final Route PutBucketPolicy = Route.builder().method(HttpMethod.PUT).path("/{bucket}").paramMatcher(params -> params.containsKey("policy")).handler(this.bucketPolicy::put).build();
    private final Route PutBucketPolicy_ = Route.builder().method(HttpMethod.PUT).path("/{bucket}/").paramMatcher(params -> params.containsKey("policy")).handler(this.bucketPolicy::put).build();
    private final Route PutBucketVersioning = Route.builder().method(HttpMethod.PUT).path("/{bucket}").paramMatcher(params -> params.containsKey("versioning")).handler((HttpRequestHandler)new PutBucketVersioningController()).build();
    private final Route PutBucketVersioning_ = Route.builder().method(HttpMethod.PUT).path("/{bucket}/").paramMatcher(params -> params.containsKey("versioning")).handler((HttpRequestHandler)new PutBucketVersioningController()).build();
    private final Route PutBucketTagging = Route.builder().method(HttpMethod.PUT).path("/{bucket}").paramMatcher(params -> params.containsKey("tagging")).handler((HttpRequestHandler)new PutBucketTaggingController()).build();
    private final Route PutBucketTagging_ = Route.builder().method(HttpMethod.PUT).path("/{bucket}/").paramMatcher(params -> params.containsKey("tagging")).handler((HttpRequestHandler)new PutBucketTaggingController()).build();
    private final Route PutObject = Route.builder().method(HttpMethod.PUT).path("/{bucket}/{*key}").handler((HttpRequestHandler)new PutObjectController()).build();
    private final Route UploadPart = Route.builder().method(HttpMethod.PUT).path("/{bucket}/{*key}").paramMatcher(params -> params.containsKey("uploadId") && params.containsKey("partNumber")).handler((HttpRequestHandler)new UploadPartController()).build();
    private final Router router = Router.router().route(this.CopyObject).route(this.CreateBucket).route(this.CreateMultipartUpload).route(this.CompleteMultipartUpload).route(this.DeleteBucket).route(this.DeleteBucketPolicy).route(this.DeleteBucketPolicy_).route(this.DeleteBucketTagging).route(this.DeleteBucketTagging_).route(this.DeleteObject).route(this.GetBucket).route(this.GetObject).route(this.GetBucketAcl).route(this.GetBucketAcl_).route(this.GetBucketPolicy).route(this.GetBucketPolicy_).route(this.GetBucketVersioning).route(this.GetBucketVersioning_).route(this.GetBucketTagging).route(this.GetBucketTagging_).route(this.HeadBucket).route(this.HeadObject).route(this.ListObjects).route(this.ListObjects_).route(this.ListObjectVersions).route(this.ListObjectVersions_).route(this.PutObject).route(this.PutBucketAcl).route(this.PutBucketAcl_).route(this.PutBucketPolicy).route(this.PutBucketPolicy_).route(this.PutBucketVersioning).route(this.PutBucketVersioning_).route(this.PutBucketTagging).route(this.PutBucketTagging_).route(this.UploadPart).notFound((HttpRequestHandler)new NotFoundHandler()).exceptionHandler(LocalS3Exception.class, (com.robothy.netty.router.ExceptionHandler)new LocalS3ExceptionHandler()).exceptionHandler(IllegalArgumentException.class, (com.robothy.netty.router.ExceptionHandler)new IllegalArgumentExceptionHandler()).exceptionHandler(Exception.class, (com.robothy.netty.router.ExceptionHandler)new ExceptionHandler());

    public static Router create() {
        return new LocalS3RouterFactory().router;
    }
}

