/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.model.request.UploadPartOptions;
import com.robothy.s3.core.service.ObjectService;
import com.robothy.s3.core.service.UploadPartService;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.model.request.DecodedAmzRequestBody;
import com.robothy.s3.rest.service.ServiceFactory;
import com.robothy.s3.rest.utils.RequestUtils;
import com.robothy.s3.rest.utils.ResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UploadPartController
implements HttpRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(UploadPartController.class);
    private final UploadPartService uploadPartService = (UploadPartService)ServiceFactory.getInstance(ObjectService.class);

    UploadPartController() {
    }

    public void handle(HttpRequest request, HttpResponse response) throws Exception {
        String bucket = RequestAssertions.assertBucketNameProvided(request);
        String key = RequestAssertions.assertObjectKeyProvided(request);
        int partNumber = RequestAssertions.assertPartNumberIsValid(request);
        String uploadId = RequestAssertions.assertUploadIdIsProvided(request);
        DecodedAmzRequestBody decodedBody = RequestUtils.getBody(request);
        this.uploadPartService.uploadPart(bucket, key, uploadId, Integer.valueOf(partNumber), UploadPartOptions.builder().contentLength(decodedBody.getDecodedContentLength()).data(decodedBody.getDecodedBody()).build());
        ResponseUtils.addAmzRequestId(response);
        ResponseUtils.addServerHeader(response);
        ResponseUtils.addDateHeader(response);
    }
}

