/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.service.BucketPolicyService;
import com.robothy.s3.core.service.BucketService;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.service.ServiceFactory;
import com.robothy.s3.rest.utils.ResponseUtils;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;

class BucketPolicyController {
    private final BucketPolicyService bucketPolicyService;

    BucketPolicyController(ServiceFactory serviceFactory) {
        this.bucketPolicyService = (BucketPolicyService)serviceFactory.getInstance(BucketService.class);
    }

    void get(HttpRequest request, HttpResponse response) {
        String bucketName = RequestAssertions.assertBucketNameProvided(request);
        String bucketPolicy = this.bucketPolicyService.getBucketPolicy(bucketName);
        response.status(HttpResponseStatus.OK).write(bucketPolicy);
        ResponseUtils.addDateHeader(response);
        ResponseUtils.addServerHeader(response);
        ResponseUtils.addAmzRequestId(response);
    }

    void put(HttpRequest request, HttpResponse response) throws IOException {
        String bucketName = RequestAssertions.assertBucketNameProvided(request);
        try (ByteBufInputStream in = new ByteBufInputStream(request.getBody());){
            this.bucketPolicyService.putBucketPolicy(bucketName, new String(in.readAllBytes()));
        }
        ResponseUtils.addDateHeader(response);
        ResponseUtils.addServerHeader(response);
        ResponseUtils.addAmzRequestId(response);
    }

    void delete(HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
        String bucketName = RequestAssertions.assertBucketNameProvided(httpRequest);
        this.bucketPolicyService.deleteBucketPolicy(bucketName);
        httpResponse.status(HttpResponseStatus.OK);
        ResponseUtils.addDateHeader(httpResponse);
        ResponseUtils.addServerHeader(httpResponse);
        ResponseUtils.addAmzRequestId(httpResponse);
    }
}

