/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.service.BucketReplicationService;
import com.robothy.s3.core.service.BucketService;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.service.ServiceFactory;
import com.robothy.s3.rest.utils.ResponseUtils;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;

public class BucketReplicationController {
    private final BucketReplicationService replicationService;

    BucketReplicationController(ServiceFactory serviceFactory) {
        this.replicationService = (BucketReplicationService)serviceFactory.getInstance(BucketService.class);
    }

    public void put(HttpRequest request, HttpResponse response) throws Exception {
        String bucketName = RequestAssertions.assertBucketNameProvided(request);
        try (ByteBufInputStream in = new ByteBufInputStream(request.getBody());){
            String replication = new String(in.readAllBytes());
            this.replicationService.putBucketReplication(bucketName, replication);
        }
        ResponseUtils.addCommonHeaders(response).status(HttpResponseStatus.OK);
    }

    public void get(HttpRequest request, HttpResponse response) throws Exception {
        String bucketName = RequestAssertions.assertBucketNameProvided(request);
        String bucketReplication = this.replicationService.getBucketReplication(bucketName);
        ResponseUtils.addCommonHeaders(response).status(HttpResponseStatus.OK).putHeader(HttpHeaderNames.CONTENT_TYPE.toString(), (Object)HttpHeaderValues.APPLICATION_XML).write(bucketReplication);
    }

    public void delete(HttpRequest request, HttpResponse response) throws Exception {
        String bucketName = RequestAssertions.assertBucketNameProvided(request);
        this.replicationService.deleteBucketReplication(bucketName);
        ResponseUtils.addCommonHeaders(response).status(HttpResponseStatus.NO_CONTENT);
    }
}

