/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.router.Route;
import com.robothy.netty.router.Router;
import com.robothy.s3.core.exception.LocalS3Exception;
import com.robothy.s3.rest.handler.BucketEncryptionController;
import com.robothy.s3.rest.handler.BucketPolicyController;
import com.robothy.s3.rest.handler.BucketReplicationController;
import com.robothy.s3.rest.handler.CompleteMultipartUploadController;
import com.robothy.s3.rest.handler.CopyObjectController;
import com.robothy.s3.rest.handler.CreateBucketController;
import com.robothy.s3.rest.handler.CreateMultipartUploadController;
import com.robothy.s3.rest.handler.DeleteBucketController;
import com.robothy.s3.rest.handler.DeleteBucketTaggingController;
import com.robothy.s3.rest.handler.DeleteObjectController;
import com.robothy.s3.rest.handler.DeleteObjectsController;
import com.robothy.s3.rest.handler.ExceptionHandler;
import com.robothy.s3.rest.handler.GetBucketAclController;
import com.robothy.s3.rest.handler.GetBucketController;
import com.robothy.s3.rest.handler.GetBucketTaggingController;
import com.robothy.s3.rest.handler.GetBucketVersioningController;
import com.robothy.s3.rest.handler.GetObjectController;
import com.robothy.s3.rest.handler.HeadBucketController;
import com.robothy.s3.rest.handler.HeadObjectController;
import com.robothy.s3.rest.handler.IllegalArgumentExceptionHandler;
import com.robothy.s3.rest.handler.ListBucketsController;
import com.robothy.s3.rest.handler.ListObjectVersionsController;
import com.robothy.s3.rest.handler.ListObjectsController;
import com.robothy.s3.rest.handler.LocalS3ExceptionHandler;
import com.robothy.s3.rest.handler.NotFoundHandler;
import com.robothy.s3.rest.handler.ObjectTaggingController;
import com.robothy.s3.rest.handler.PutBucketAclController;
import com.robothy.s3.rest.handler.PutBucketTaggingController;
import com.robothy.s3.rest.handler.PutBucketVersioningController;
import com.robothy.s3.rest.handler.PutObjectController;
import com.robothy.s3.rest.handler.UploadPartController;
import com.robothy.s3.rest.service.ServiceFactory;
import io.netty.handler.codec.http.HttpMethod;
import java.util.Objects;

public class LocalS3RouterFactory {
    public static Router create(ServiceFactory serviceFactory) {
        Objects.requireNonNull(serviceFactory);
        BucketPolicyController bucketPolicy = new BucketPolicyController(serviceFactory);
        BucketReplicationController bucketReplicationController = new BucketReplicationController(serviceFactory);
        BucketEncryptionController bucketEncryptionController = new BucketEncryptionController(serviceFactory);
        ObjectTaggingController objectTaggingController = new ObjectTaggingController(serviceFactory);
        Route CopyObject = Route.builder().method(HttpMethod.PUT).path("/{bucket}/{*key}").headerMatcher(headers -> headers.containsKey("x-amz-copy-source")).handler((HttpRequestHandler)new CopyObjectController(serviceFactory)).build();
        Route CreateBucket = Route.builder().method(HttpMethod.PUT).path("/{bucket}").handler((HttpRequestHandler)new CreateBucketController(serviceFactory)).build();
        Route PutBucketReplication = Route.builder().method(HttpMethod.PUT).path("/{bucket}").paramMatcher(params -> params.containsKey("replication")).handler(bucketReplicationController::put).build();
        Route PutBucketReplication_ = Route.builder().method(HttpMethod.PUT).path("/{bucket}/").paramMatcher(params -> params.containsKey("replication")).handler(bucketReplicationController::put).build();
        Route PutBucketEncryption = Route.builder().method(HttpMethod.PUT).path("/{bucket}").paramMatcher(params -> params.containsKey("encryption")).handler(bucketEncryptionController::put).build();
        Route PutBucketEncryption_ = Route.builder().method(HttpMethod.PUT).path("/{bucket}/").paramMatcher(params -> params.containsKey("encryption")).handler(bucketEncryptionController::put).build();
        Route CreateMultipartUpload = Route.builder().method(HttpMethod.POST).path("/{bucket}/{*key}").paramMatcher(params -> params.containsKey("uploads")).handler((HttpRequestHandler)new CreateMultipartUploadController(serviceFactory)).build();
        Route CompleteMultipartUpload2 = Route.builder().method(HttpMethod.POST).path("/{bucket}/{*key}").handler((HttpRequestHandler)new CompleteMultipartUploadController(serviceFactory)).build();
        Route DeleteObjects = Route.builder().method(HttpMethod.POST).path("/{bucket}").paramMatcher(params -> params.containsKey("delete")).handler((HttpRequestHandler)new DeleteObjectsController(serviceFactory)).build();
        Route DeleteObjects_ = Route.builder().method(HttpMethod.POST).path("/{bucket}/").paramMatcher(params -> params.containsKey("delete")).handler((HttpRequestHandler)new DeleteObjectsController(serviceFactory)).build();
        Route PutObjectTagging = Route.builder().method(HttpMethod.PUT).path("/{bucket}/{*key}").paramMatcher(params -> params.containsKey("tagging")).handler(objectTaggingController::put).build();
        Route DeleteBucket = Route.builder().method(HttpMethod.DELETE).path("/{bucket}").handler((HttpRequestHandler)new DeleteBucketController(serviceFactory)).build();
        Route DeleteBucketEncryption = Route.builder().method(HttpMethod.DELETE).path("/{bucket}").paramMatcher(params -> params.containsKey("encryption")).handler(bucketEncryptionController::delete).build();
        Route DeleteBucketEncryption_ = Route.builder().method(HttpMethod.DELETE).path("/{bucket}/").paramMatcher(params -> params.containsKey("encryption")).handler(bucketEncryptionController::delete).build();
        Route DeleteBucketPolicy = Route.builder().method(HttpMethod.DELETE).path("/{bucket}").paramMatcher(params -> params.containsKey("policy")).handler(bucketPolicy::delete).build();
        Route DeleteBucketPolicy_ = Route.builder().method(HttpMethod.DELETE).path("/{bucket}/").paramMatcher(params -> params.containsKey("policy")).handler(bucketPolicy::delete).build();
        Route DeleteBucketReplication = Route.builder().method(HttpMethod.DELETE).path("/{bucket}/").paramMatcher(params -> params.containsKey("replication")).handler(bucketReplicationController::delete).build();
        Route DeleteBucketReplication_ = Route.builder().method(HttpMethod.DELETE).path("/{bucket}/").paramMatcher(params -> params.containsKey("replication")).handler(bucketReplicationController::delete).build();
        Route DeleteBucketTagging = Route.builder().method(HttpMethod.DELETE).path("/{bucket}").paramMatcher(params -> params.containsKey("tagging")).handler((HttpRequestHandler)new DeleteBucketTaggingController(serviceFactory)).build();
        Route DeleteBucketTagging_ = Route.builder().method(HttpMethod.DELETE).path("/{bucket}/").paramMatcher(params -> params.containsKey("tagging")).handler((HttpRequestHandler)new DeleteBucketTaggingController(serviceFactory)).build();
        Route DeleteObject = Route.builder().method(HttpMethod.DELETE).path("/{bucket}/{*key}").handler((HttpRequestHandler)new DeleteObjectController(serviceFactory)).build();
        Route DeleteObjectTagging = Route.builder().method(HttpMethod.DELETE).path("/{bucket}/{*key}").paramMatcher(params -> params.containsKey("tagging")).handler(objectTaggingController::delete).build();
        Route ListBuckets = Route.builder().method(HttpMethod.GET).path("/").handler((HttpRequestHandler)new ListBucketsController(serviceFactory)).build();
        Route GetBucket = Route.builder().method(HttpMethod.GET).path("/v20180820/bucket/{bucket}").handler((HttpRequestHandler)new GetBucketController(serviceFactory)).build();
        Route GetBucketAcl = Route.builder().method(HttpMethod.GET).path("/{bucket}").paramMatcher(params -> params.containsKey("acl")).handler((HttpRequestHandler)new GetBucketAclController(serviceFactory)).build();
        Route GetBucketAcl_ = Route.builder().method(HttpMethod.GET).path("/{bucket}/").paramMatcher(params -> params.containsKey("acl")).handler((HttpRequestHandler)new GetBucketAclController(serviceFactory)).build();
        Route GetBucketReplication = Route.builder().method(HttpMethod.GET).path("/{bucket}").paramMatcher(params -> params.containsKey("replication")).handler(bucketReplicationController::get).build();
        Route GetBucketReplication_ = Route.builder().method(HttpMethod.GET).path("/{bucket}/").paramMatcher(params -> params.containsKey("replication")).handler(bucketReplicationController::get).build();
        Route GetBucketEncryption = Route.builder().method(HttpMethod.GET).path("/{bucket}").paramMatcher(params -> params.containsKey("encryption")).handler(bucketEncryptionController::get).build();
        Route GetBucketEncryption_ = Route.builder().method(HttpMethod.GET).path("/{bucket}/").paramMatcher(params -> params.containsKey("encryption")).handler(bucketEncryptionController::get).build();
        Route GetBucketPolicy = Route.builder().method(HttpMethod.GET).path("/{bucket}").paramMatcher(params -> params.containsKey("policy")).handler(bucketPolicy::get).build();
        Route GetBucketPolicy_ = Route.builder().method(HttpMethod.GET).path("/{bucket}/").paramMatcher(params -> params.containsKey("policy")).handler(bucketPolicy::get).build();
        Route GetBucketVersioning = Route.builder().method(HttpMethod.GET).path("/{bucket}").paramMatcher(params -> params.containsKey("versioning")).handler((HttpRequestHandler)new GetBucketVersioningController(serviceFactory)).build();
        Route GetBucketVersioning_ = Route.builder().method(HttpMethod.GET).path("/{bucket}/").paramMatcher(params -> params.containsKey("versioning")).handler((HttpRequestHandler)new GetBucketVersioningController(serviceFactory)).build();
        Route GetBucketTagging = Route.builder().method(HttpMethod.GET).path("/{bucket}").paramMatcher(params -> params.containsKey("tagging")).handler((HttpRequestHandler)new GetBucketTaggingController(serviceFactory)).build();
        Route GetBucketTagging_ = Route.builder().method(HttpMethod.GET).path("/{bucket}/").paramMatcher(params -> params.containsKey("tagging")).handler((HttpRequestHandler)new GetBucketTaggingController(serviceFactory)).build();
        Route GetObject = Route.builder().method(HttpMethod.GET).path("/{bucket}/{*key}").handler((HttpRequestHandler)new GetObjectController(serviceFactory)).build();
        Route GetObjectTagging = Route.builder().method(HttpMethod.GET).path("/{bucket}/{*key}").paramMatcher(params -> params.containsKey("tagging")).handler(objectTaggingController::get).build();
        Route HeadBucket = Route.builder().method(HttpMethod.HEAD).path("/{bucket}").handler((HttpRequestHandler)new HeadBucketController(serviceFactory)).build();
        Route HeadObject = Route.builder().method(HttpMethod.HEAD).path("/{bucket}/{*key}").handler((HttpRequestHandler)new HeadObjectController(serviceFactory)).build();
        Route ListObjects = Route.builder().method(HttpMethod.GET).path("/{bucket}").handler((HttpRequestHandler)new ListObjectsController(serviceFactory)).build();
        Route ListObjects_ = Route.builder().method(HttpMethod.GET).path("/{bucket}/").handler((HttpRequestHandler)new ListObjectsController(serviceFactory)).build();
        Route ListObjectVersions = Route.builder().method(HttpMethod.GET).path("/{bucket}").paramMatcher(params -> params.containsKey("versions")).handler((HttpRequestHandler)new ListObjectVersionsController(serviceFactory)).build();
        Route ListObjectVersions_ = Route.builder().method(HttpMethod.GET).path("/{bucket}/").paramMatcher(params -> params.containsKey("versions")).handler((HttpRequestHandler)new ListObjectVersionsController(serviceFactory)).build();
        Route PutBucketAcl = Route.builder().method(HttpMethod.PUT).path("/{bucket}").paramMatcher(params -> params.containsKey("acl")).handler((HttpRequestHandler)new PutBucketAclController(serviceFactory)).build();
        Route PutBucketAcl_ = Route.builder().method(HttpMethod.PUT).path("/{bucket}/").paramMatcher(params -> params.containsKey("acl")).handler((HttpRequestHandler)new PutBucketAclController(serviceFactory)).build();
        Route PutBucketPolicy = Route.builder().method(HttpMethod.PUT).path("/{bucket}").paramMatcher(params -> params.containsKey("policy")).handler(bucketPolicy::put).build();
        Route PutBucketPolicy_ = Route.builder().method(HttpMethod.PUT).path("/{bucket}/").paramMatcher(params -> params.containsKey("policy")).handler(bucketPolicy::put).build();
        Route PutBucketVersioning = Route.builder().method(HttpMethod.PUT).path("/{bucket}").paramMatcher(params -> params.containsKey("versioning")).handler((HttpRequestHandler)new PutBucketVersioningController(serviceFactory)).build();
        Route PutBucketVersioning_ = Route.builder().method(HttpMethod.PUT).path("/{bucket}/").paramMatcher(params -> params.containsKey("versioning")).handler((HttpRequestHandler)new PutBucketVersioningController(serviceFactory)).build();
        Route PutBucketTagging = Route.builder().method(HttpMethod.PUT).path("/{bucket}").paramMatcher(params -> params.containsKey("tagging")).handler((HttpRequestHandler)new PutBucketTaggingController(serviceFactory)).build();
        Route PutBucketTagging_ = Route.builder().method(HttpMethod.PUT).path("/{bucket}/").paramMatcher(params -> params.containsKey("tagging")).handler((HttpRequestHandler)new PutBucketTaggingController(serviceFactory)).build();
        Route PutObject = Route.builder().method(HttpMethod.PUT).path("/{bucket}/{*key}").handler((HttpRequestHandler)new PutObjectController(serviceFactory)).build();
        Route UploadPart = Route.builder().method(HttpMethod.PUT).path("/{bucket}/{*key}").paramMatcher(params -> params.containsKey("uploadId") && params.containsKey("partNumber")).handler((HttpRequestHandler)new UploadPartController(serviceFactory)).build();
        return Router.router().route(CopyObject).route(CreateBucket).route(CreateMultipartUpload).route(CompleteMultipartUpload2).route(DeleteBucket).route(DeleteBucketEncryption_).route(DeleteBucketEncryption).route(DeleteBucketPolicy).route(DeleteBucketPolicy_).route(DeleteBucketReplication_).route(DeleteBucketReplication).route(DeleteBucketTagging).route(DeleteBucketTagging_).route(DeleteObject).route(DeleteObjects).route(DeleteObjects_).route(DeleteObjectTagging).route(ListBuckets).route(GetBucket).route(GetObject).route(GetBucketAcl).route(GetBucketAcl_).route(GetBucketEncryption).route(GetBucketEncryption_).route(GetBucketPolicy).route(GetBucketPolicy_).route(GetBucketReplication).route(GetBucketReplication_).route(GetBucketVersioning).route(GetBucketVersioning_).route(GetBucketTagging).route(GetBucketTagging_).route(GetObjectTagging).route(HeadBucket).route(HeadObject).route(ListObjects).route(ListObjects_).route(ListObjectVersions).route(ListObjectVersions_).route(PutObject).route(PutBucketAcl).route(PutBucketAcl_).route(PutBucketEncryption).route(PutBucketEncryption_).route(PutBucketPolicy).route(PutBucketPolicy_).route(PutBucketReplication).route(PutBucketReplication_).route(PutBucketVersioning).route(PutBucketVersioning_).route(PutBucketTagging).route(PutBucketTagging_).route(PutObjectTagging).route(UploadPart).notFound((HttpRequestHandler)new NotFoundHandler()).exceptionHandler(LocalS3Exception.class, (com.robothy.netty.router.ExceptionHandler)new LocalS3ExceptionHandler(serviceFactory)).exceptionHandler(IllegalArgumentException.class, (com.robothy.netty.router.ExceptionHandler)new IllegalArgumentExceptionHandler()).exceptionHandler(Exception.class, (com.robothy.netty.router.ExceptionHandler)new ExceptionHandler());
    }
}

