/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.service.BucketService;
import com.robothy.s3.datatypes.Tagging;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.service.ServiceFactory;
import com.robothy.s3.rest.utils.ResponseUtils;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Collection;

class GetBucketTaggingController
implements HttpRequestHandler {
    private final BucketService bucketService;
    private final XmlMapper xmlMapper;

    GetBucketTaggingController(ServiceFactory serviceFactory) {
        this.bucketService = serviceFactory.getInstance(BucketService.class);
        this.xmlMapper = serviceFactory.getInstance(XmlMapper.class);
    }

    public void handle(HttpRequest request, HttpResponse response) throws Exception {
        String bucketName = RequestAssertions.assertBucketNameProvided(request);
        Collection tagSets = this.bucketService.getTagging(bucketName);
        Tagging tagging = Tagging.fromCollection((Collection)tagSets);
        String responseBody = this.xmlMapper.writeValueAsString((Object)tagging);
        response.write(responseBody);
        response.status(HttpResponseStatus.OK);
        ResponseUtils.addDateHeader(response);
        ResponseUtils.addServerHeader(response);
    }
}

