/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.model.answers.GetObjectAns;
import com.robothy.s3.core.model.request.GetObjectOptions;
import com.robothy.s3.core.service.ObjectService;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.service.ServiceFactory;
import com.robothy.s3.rest.utils.ByteBufUtils;
import com.robothy.s3.rest.utils.ResponseUtils;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;

class GetObjectController
implements HttpRequestHandler {
    private final ObjectService objectService;

    GetObjectController(ServiceFactory serviceFactory) {
        this.objectService = serviceFactory.getInstance(ObjectService.class);
    }

    public void handle(HttpRequest request, HttpResponse response) throws Exception {
        GetObjectOptions options;
        String key;
        String bucket = RequestAssertions.assertBucketNameProvided(request);
        GetObjectAns getObjectAns = this.objectService.getObject(bucket, key = RequestAssertions.assertObjectKeyProvided(request), options = GetObjectOptions.builder().versionId((String)request.parameter("versionId").orElse(null)).build());
        if (getObjectAns.isDeleteMarker()) {
            response.status(HttpResponseStatus.METHOD_NOT_ALLOWED);
            response.putHeader(HttpHeaderNames.ALLOW.toString(), (Object)HttpMethod.DELETE).putHeader("x-amz-delete-marker", (Object)true);
        } else {
            ByteBuf content = ByteBufUtils.fromInputStream(getObjectAns.getContent());
            ResponseUtils.addCommonHeaders(response);
            ResponseUtils.addETag(response, getObjectAns.getEtag());
            response.status(HttpResponseStatus.OK).write(content).putHeader(HttpHeaderNames.CONTENT_TYPE.toString(), (Object)getObjectAns.getContentType()).putHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), (Object)getObjectAns.getSize());
        }
        response.putHeader("x-amz-version-id", (Object)getObjectAns.getVersionId());
        ResponseUtils.addDateHeader(response);
        ResponseUtils.addAmzRequestId(response);
        ResponseUtils.addServerHeader(response);
    }
}

