/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.netty.http;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HttpRequest {
    private Map<CharSequence, String> headers;
    private Map<CharSequence, List<String>> params;
    private String path;
    private String uri;
    private HttpMethod method;
    private ByteBuf body;
    private HttpVersion httpVersion;

    public Optional<String> header(CharSequence name) {
        Objects.requireNonNull(name, "The header name shouldn't be null.");
        return Optional.ofNullable(this.headers.get(name.toString().toLowerCase(Locale.ROOT)));
    }

    public Optional<String> parameter(String name) {
        if (this.params.containsKey(name) && this.params.get(name).size() > 0) {
            return Optional.ofNullable(this.params.get(name).get(0));
        }
        return Optional.empty();
    }

    public Optional<List<String>> parameters(String name) {
        return Optional.ofNullable(this.params.get(name));
    }

    private static Map<CharSequence, String> $default$headers() {
        return new HashMap<CharSequence, String>();
    }

    private static Map<CharSequence, List<String>> $default$params() {
        return new HashMap<CharSequence, List<String>>();
    }

    HttpRequest(Map<CharSequence, String> headers, Map<CharSequence, List<String>> params, String path, String uri, HttpMethod method, ByteBuf body, HttpVersion httpVersion) {
        this.headers = headers;
        this.params = params;
        this.path = path;
        this.uri = uri;
        this.method = method;
        this.body = body;
        this.httpVersion = httpVersion;
    }

    public static HttpRequestBuilder builder() {
        return new HttpRequestBuilder();
    }

    public Map<CharSequence, String> getHeaders() {
        return this.headers;
    }

    public Map<CharSequence, List<String>> getParams() {
        return this.params;
    }

    public String getPath() {
        return this.path;
    }

    public String getUri() {
        return this.uri;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public ByteBuf getBody() {
        return this.body;
    }

    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    public static class HttpRequestBuilder {
        private boolean headers$set;
        private Map<CharSequence, String> headers$value;
        private boolean params$set;
        private Map<CharSequence, List<String>> params$value;
        private String path;
        private String uri;
        private HttpMethod method;
        private ByteBuf body;
        private HttpVersion httpVersion;

        HttpRequestBuilder() {
        }

        public HttpRequestBuilder headers(Map<CharSequence, String> headers) {
            this.headers$value = headers;
            this.headers$set = true;
            return this;
        }

        public HttpRequestBuilder params(Map<CharSequence, List<String>> params) {
            this.params$value = params;
            this.params$set = true;
            return this;
        }

        public HttpRequestBuilder path(String path) {
            this.path = path;
            return this;
        }

        public HttpRequestBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public HttpRequestBuilder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public HttpRequestBuilder body(ByteBuf body) {
            this.body = body;
            return this;
        }

        public HttpRequestBuilder httpVersion(HttpVersion httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        public HttpRequest build() {
            Map headers$value = this.headers$value;
            if (!this.headers$set) {
                headers$value = HttpRequest.$default$headers();
            }
            Map params$value = this.params$value;
            if (!this.params$set) {
                params$value = HttpRequest.$default$params();
            }
            return new HttpRequest(headers$value, params$value, this.path, this.uri, this.method, this.body, this.httpVersion);
        }

        public String toString() {
            return "HttpRequest.HttpRequestBuilder(headers$value=" + this.headers$value + ", params$value=" + this.params$value + ", path=" + this.path + ", uri=" + this.uri + ", method=" + this.method + ", body=" + this.body + ", httpVersion=" + this.httpVersion + ")";
        }
    }
}

