/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.netty.initializer;

import com.robothy.netty.codec.HttpMessageHandler;
import com.robothy.netty.codec.HttpRequestDecoder;
import com.robothy.netty.router.Router;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.util.concurrent.EventExecutorGroup;

public class HttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final EventExecutorGroup executorGroup;
    private final Router router;

    public HttpServerInitializer(EventExecutorGroup executorGroup, Router router) {
        this.executorGroup = executorGroup;
        this.router = router;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        ch.config().setConnectTimeoutMillis(10000);
        ch.config().setAutoClose(true);
        pipeline.addLast("http-request-decoder", (ChannelHandler)new io.netty.handler.codec.http.HttpRequestDecoder());
        pipeline.addLast("http-response-encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast(this.executorGroup, "router-http-request-decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast(this.executorGroup, "router-http-response-encoder", (ChannelHandler)new com.robothy.netty.codec.HttpResponseEncoder());
        pipeline.addLast(this.executorGroup, "router-http-message-handler", (ChannelHandler)new HttpMessageHandler(this.router));
    }
}

