/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.netty.router;

import com.robothy.netty.http.HttpRequestHandler;
import io.netty.handler.codec.http.HttpMethod;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class Route {
    private HttpMethod method;
    private String path;
    private HttpRequestHandler handler;
    private Function<Map<CharSequence, String>, Boolean> headerMatcher;
    private Function<Map<CharSequence, List<String>>, Boolean> paramMatcher;
    private String trimPath;

    private Route() {
    }

    public Route headerMather(Function<Map<CharSequence, String>, Boolean> headerMatcher) {
        this.headerMatcher = headerMatcher;
        return this;
    }

    public Route paramMatcher(Function<Map<CharSequence, List<String>>, Boolean> paramMatcher) {
        this.paramMatcher = paramMatcher;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Route route = (Route)o;
        return this.method.equals((Object)route.method) && this.trimPath.equals(route.trimPath) && Objects.equals(this.headerMatcher, route.headerMatcher) && Objects.equals(this.paramMatcher, route.paramMatcher);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.trimPath, this.headerMatcher, this.paramMatcher);
    }

    public static Builder builder() {
        return new Builder();
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public HttpRequestHandler getHandler() {
        return this.handler;
    }

    public Function<Map<CharSequence, String>, Boolean> getHeaderMatcher() {
        return this.headerMatcher;
    }

    public Function<Map<CharSequence, List<String>>, Boolean> getParamMatcher() {
        return this.paramMatcher;
    }

    public String getTrimPath() {
        return this.trimPath;
    }

    public static class Builder {
        Route propHolder = new Route();

        public Builder method(HttpMethod method) {
            this.propHolder.method = method;
            return this;
        }

        public Builder path(String path) {
            this.propHolder.path = path;
            return this;
        }

        public Builder headerMatcher(Function<Map<CharSequence, String>, Boolean> headerMatcher) {
            this.propHolder.headerMatcher = headerMatcher;
            return this;
        }

        public Builder paramMatcher(Function<Map<CharSequence, List<String>>, Boolean> paramMatcher) {
            this.propHolder.paramMatcher = paramMatcher;
            return this;
        }

        public Builder handler(HttpRequestHandler handler) {
            this.propHolder.handler = handler;
            return this;
        }

        private String trimPath(String path) {
            String[] segments = path.split("/");
            StringBuilder result = new StringBuilder();
            for (String seg : segments) {
                if (seg.startsWith("{") && seg.endsWith("}")) {
                    result.append("/{}");
                    continue;
                }
                result.append('/').append(seg);
            }
            return result.toString();
        }

        public Route build() {
            Objects.requireNonNull(this.propHolder.method, "'method' is required.");
            Objects.requireNonNull(this.propHolder.path, "'path' is required.");
            Objects.requireNonNull(this.propHolder.handler, "'handler'' is required.");
            Route route = new Route();
            route.method = this.propHolder.method;
            route.path = this.propHolder.path;
            route.handler = this.propHolder.handler;
            route.paramMatcher = this.propHolder.paramMatcher;
            route.headerMatcher = this.propHolder.headerMatcher;
            route.trimPath = this.trimPath(route.path);
            return route;
        }
    }
}

