/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.netty.router;

import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.router.AbstractRouter;
import com.robothy.netty.router.Route;
import com.robothy.netty.router.Router;
import io.netty.handler.codec.http.HttpMethod;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import org.springframework.http.server.PathContainer;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import org.springframework.web.util.pattern.PatternParseException;

public class SpringWebRouter
extends AbstractRouter {
    private final Map<HttpMethod, TreeSet<ParsedPattern>> parsedPatternMap = new HashMap<HttpMethod, TreeSet<ParsedPattern>>();

    @Override
    public Router route(Route rule) {
        Objects.requireNonNull(rule);
        this.parsedPatternMap.putIfAbsent(rule.getMethod(), new TreeSet<ParsedPattern>(ParsedPattern.COMPARATOR));
        ParsedPattern parsedPattern = new ParsedPattern();
        try {
            parsedPattern.pathPattern = PathPatternParser.defaultInstance.parse(rule.getPath());
        }
        catch (PatternParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        parsedPattern.headersMather = rule.getHeaderMatcher();
        parsedPattern.paramsMather = rule.getParamMatcher();
        parsedPattern.handler = rule.getHandler();
        this.parsedPatternMap.get(rule.getMethod()).add(parsedPattern);
        return this;
    }

    @Override
    public HttpRequestHandler match(HttpRequest request) {
        return this.matchAndExtract(request).orElse(this.notFoundHandler());
    }

    private Optional<HttpRequestHandler> matchAndExtract(HttpRequest request) {
        PathContainer pathContainer = PathContainer.parsePath((String)request.getPath());
        if (!this.parsedPatternMap.containsKey(request.getMethod())) {
            return Optional.empty();
        }
        for (ParsedPattern parsedPattern : this.parsedPatternMap.get(request.getMethod())) {
            PathPattern.PathMatchInfo pathMatchInfo = parsedPattern.pathPattern.matchAndExtract(pathContainer);
            if (!Objects.nonNull(pathMatchInfo)) continue;
            boolean headerMatched = Optional.ofNullable(parsedPattern.headersMather).map(matcher -> (Boolean)matcher.apply(request.getHeaders())).orElse(true);
            boolean parameterMatched = Optional.ofNullable(parsedPattern.paramsMather).map(matcher -> (Boolean)matcher.apply(request.getParams())).orElse(true);
            if (!headerMatched || !parameterMatched) continue;
            Map params = Optional.ofNullable(request.getParams()).orElse(new HashMap());
            pathMatchInfo.getUriVariables().forEach((key, value) -> {
                if (params.containsKey(key)) {
                    ((List)params.get(key)).add(value);
                } else {
                    ArrayList<String> values = new ArrayList<String>(1);
                    values.add((String)value);
                    params.put(key, values);
                }
            });
            return Optional.of(parsedPattern.handler);
        }
        return Optional.ofNullable(this.staticResourceMatcher().match(request));
    }

    static class ParsedPattern {
        PathPattern pathPattern;
        Function<Map<CharSequence, String>, Boolean> headersMather;
        Function<Map<CharSequence, List<String>>, Boolean> paramsMather;
        private HttpRequestHandler handler;
        static Comparator<ParsedPattern> COMPARATOR = Comparator.comparing(ParsedPattern::headersMather, Comparator.nullsLast((a, b) -> 0)).thenComparing(ParsedPattern::paramsMather, Comparator.nullsLast((a, b) -> 0)).thenComparing(ParsedPattern::pathPattern, PathPattern.SPECIFICITY_COMPARATOR).thenComparing(Object::hashCode);

        ParsedPattern() {
        }

        Function<Map<CharSequence, String>, Boolean> headersMather() {
            return this.headersMather;
        }

        Function<Map<CharSequence, List<String>>, Boolean> paramsMather() {
            return this.paramsMather;
        }

        public PathPattern pathPattern() {
            return this.pathPattern;
        }
    }
}

