/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger.loader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wordnik.swagger.models.Swagger;
import com.wordnik.swagger.util.Json;
import com.wordnik.swagger.util.Yaml;
import java.io.IOException;
import org.apache.commons.lang3.Validate;

public class Swagger20Parser {
    public static Swagger parse(String swagger) throws IOException {
        Validate.notEmpty((CharSequence)swagger, (String)"swagger String must not be empty!", (Object[])new Object[0]);
        return Swagger20Parser.convertToSwagger(swagger);
    }

    private static Swagger convertToSwagger(String data) throws IOException {
        ObjectMapper mapper = data.trim().startsWith("{") ? Json.mapper() : Yaml.mapper();
        JsonNode rootNode = mapper.readTree(data);
        JsonNode swaggerNode = rootNode.get("swagger");
        if (swaggerNode == null) {
            throw new IllegalArgumentException("Swagger String has an invalid format.");
        }
        return (Swagger)mapper.convertValue((Object)rootNode, Swagger.class);
    }
}

