/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger.test;

import com.wordnik.swagger.models.ArrayModel;
import com.wordnik.swagger.models.Model;
import com.wordnik.swagger.models.ModelImpl;
import com.wordnik.swagger.models.Operation;
import com.wordnik.swagger.models.Path;
import com.wordnik.swagger.models.RefModel;
import com.wordnik.swagger.models.Response;
import com.wordnik.swagger.models.Swagger;
import com.wordnik.swagger.models.parameters.BodyParameter;
import com.wordnik.swagger.models.parameters.CookieParameter;
import com.wordnik.swagger.models.parameters.FormParameter;
import com.wordnik.swagger.models.parameters.HeaderParameter;
import com.wordnik.swagger.models.parameters.Parameter;
import com.wordnik.swagger.models.parameters.PathParameter;
import com.wordnik.swagger.models.parameters.QueryParameter;
import com.wordnik.swagger.models.parameters.RefParameter;
import com.wordnik.swagger.models.properties.ArrayProperty;
import com.wordnik.swagger.models.properties.Property;
import com.wordnik.swagger.models.properties.RefProperty;
import com.wordnik.swagger.models.properties.StringProperty;
import io.swagger.parser.SwaggerParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertionMapAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.StringAssert;

public class SwaggerAssert
extends AbstractAssert<SwaggerAssert, Swagger> {
    private SoftAssertions softAssertions = new SoftAssertions();

    public SwaggerAssert(Swagger actual) {
        super((Object)actual, SwaggerAssert.class);
    }

    public SwaggerAssert isEqualTo(Swagger expected) {
        this.validateSwagger(expected);
        return (SwaggerAssert)this.myself;
    }

    public SwaggerAssert isEqualTo(String expectedLocation) {
        this.validateSwagger(new SwaggerParser().read(expectedLocation));
        return (SwaggerAssert)this.myself;
    }

    private void validateSwagger(Swagger expected) {
        this.validatePaths(((Swagger)this.actual).getPaths(), expected.getPaths());
        this.validateDefinitions(((Swagger)this.actual).getDefinitions(), expected.getDefinitions());
        this.softAssertions.assertAll();
    }

    private void validatePaths(Map<String, Path> actualPaths, Map<String, Path> expectedPaths) {
        if (MapUtils.isNotEmpty(expectedPaths)) {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualPaths).as("Checking Paths", new Object[0])).isNotEmpty();
            if (MapUtils.isNotEmpty(actualPaths)) {
                ((IterableAssert)this.softAssertions.assertThat(actualPaths.keySet()).as("Checking Paths", new Object[0])).hasSameElementsAs(expectedPaths.keySet());
                for (Map.Entry<String, Path> actualPathEntry : actualPaths.entrySet()) {
                    Path expectedPath = expectedPaths.get(actualPathEntry.getKey());
                    Path actualPath = actualPathEntry.getValue();
                    String pathName = actualPathEntry.getKey();
                    this.validatePath(pathName, actualPath, expectedPath);
                }
            }
        } else {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualPaths).as("Checking Paths", new Object[0])).isNullOrEmpty();
        }
    }

    private void validateDefinitions(Map<String, Model> actualDefinitions, Map<String, Model> expectedDefinitions) {
        if (MapUtils.isNotEmpty(expectedDefinitions)) {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualDefinitions).as("Checking Definitions", new Object[0])).isNotEmpty();
            if (MapUtils.isNotEmpty(actualDefinitions)) {
                ((IterableAssert)this.softAssertions.assertThat(actualDefinitions.keySet()).as("Checking Definitions", new Object[0])).hasSameElementsAs(expectedDefinitions.keySet());
                for (Map.Entry<String, Model> actualDefinitionEntry : actualDefinitions.entrySet()) {
                    Model expectedDefinition = expectedDefinitions.get(actualDefinitionEntry.getKey());
                    Model actualDefinition = actualDefinitionEntry.getValue();
                    String definitionName = actualDefinitionEntry.getKey();
                    this.validateDefinition(definitionName, actualDefinition, expectedDefinition);
                }
            }
        } else {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualDefinitions).as("Checking Definitions", new Object[0])).isNullOrEmpty();
        }
    }

    private void validatePath(String pathName, Path actualPath, Path expectedPath) {
        if (expectedPath != null) {
            ((ListAssert)this.softAssertions.assertThat(actualPath.getOperations()).as("Checking number of operations of path '%s'", new Object[]{pathName})).hasSameSizeAs((Iterable)actualPath.getOperations());
            this.validateOperation(actualPath.getGet(), expectedPath.getGet(), pathName, "GET");
            this.validateOperation(actualPath.getDelete(), expectedPath.getDelete(), pathName, "DELETE");
            this.validateOperation(actualPath.getPost(), expectedPath.getPost(), pathName, "POST");
            this.validateOperation(actualPath.getPut(), expectedPath.getPut(), pathName, "PUT");
            this.validateOperation(actualPath.getPatch(), expectedPath.getPatch(), pathName, "PATCH");
            this.validateOperation(actualPath.getOptions(), expectedPath.getOptions(), pathName, "OPTIONS");
        }
    }

    private void validateDefinition(String definitionName, Model actualDefinition, Model expectedDefinition) {
        if (expectedDefinition != null) {
            this.validateModel(actualDefinition, expectedDefinition, String.format("Checking model of definition '%s", definitionName));
            this.validateDefinitionProperties(actualDefinition.getProperties(), expectedDefinition.getProperties(), definitionName);
        }
    }

    private void validateModel(Model actualDefinition, Model expectedDefinition, String message) {
        if (expectedDefinition instanceof ModelImpl) {
            ((ObjectAssert)this.softAssertions.assertThat((Object)actualDefinition).as(message, new Object[0])).isExactlyInstanceOf(ModelImpl.class);
        } else if (expectedDefinition instanceof RefModel) {
            ((ObjectAssert)this.softAssertions.assertThat((Object)actualDefinition).as(message, new Object[0])).isExactlyInstanceOf(RefModel.class);
        } else if (expectedDefinition instanceof ArrayModel) {
            ArrayModel arrayModel = (ArrayModel)expectedDefinition;
            ((ObjectAssert)this.softAssertions.assertThat((Object)actualDefinition).as(message, new Object[0])).isExactlyInstanceOf(ArrayModel.class);
        } else {
            this.softAssertions.assertThat((Object)actualDefinition).isExactlyInstanceOf(expectedDefinition.getClass());
        }
    }

    private void validateDefinitionProperties(Map<String, Property> actualDefinitionProperties, Map<String, Property> expectedDefinitionProperties, String definitionName) {
        if (MapUtils.isNotEmpty(expectedDefinitionProperties)) {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualDefinitionProperties).as("Checking properties of definition '%s", new Object[]{definitionName})).isNotEmpty();
            if (MapUtils.isNotEmpty(actualDefinitionProperties)) {
                ((IterableAssert)this.softAssertions.assertThat(actualDefinitionProperties.keySet()).as("Checking properties of definition '%s'", new Object[]{definitionName})).hasSameElementsAs(expectedDefinitionProperties.keySet());
                for (Map.Entry<String, Property> actualDefinitionPropertyEntry : actualDefinitionProperties.entrySet()) {
                    Property expectedDefinitionProperty = expectedDefinitionProperties.get(actualDefinitionPropertyEntry.getKey());
                    Property actualDefinitionProperty = actualDefinitionPropertyEntry.getValue();
                    String propertyName = actualDefinitionPropertyEntry.getKey();
                    this.validateProperty(actualDefinitionProperty, expectedDefinitionProperty, String.format("Checking property '%s' of definition '%s'", propertyName, definitionName));
                }
            }
        } else {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualDefinitionProperties).as("Checking properties of definition '%s", new Object[]{definitionName})).isNullOrEmpty();
        }
    }

    private void validateProperty(Property actualProperty, Property expectedProperty, String message) {
        if (expectedProperty != null) {
            if (expectedProperty instanceof RefProperty) {
                RefProperty refProperty = (RefProperty)expectedProperty;
                ((ObjectAssert)this.softAssertions.assertThat((Object)actualProperty).as(message, new Object[0])).isExactlyInstanceOf(RefProperty.class);
            } else if (expectedProperty instanceof ArrayProperty) {
                ArrayProperty arrayProperty = (ArrayProperty)expectedProperty;
                ((ObjectAssert)this.softAssertions.assertThat((Object)actualProperty).as(message, new Object[0])).isExactlyInstanceOf(ArrayProperty.class);
            } else if (expectedProperty instanceof StringProperty) {
                StringProperty expectedStringProperty = (StringProperty)expectedProperty;
                ((ObjectAssert)this.softAssertions.assertThat((Object)actualProperty).as(message, new Object[0])).isExactlyInstanceOf(StringProperty.class);
                if (actualProperty instanceof StringProperty) {
                    StringProperty actualStringProperty = (StringProperty)expectedProperty;
                    List expectedEnums = expectedStringProperty.getEnum();
                    if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
                        this.softAssertions.assertThat(actualStringProperty.getEnum()).hasSameElementsAs((Iterable)expectedEnums);
                    } else {
                        this.softAssertions.assertThat(actualStringProperty.getEnum()).isNullOrEmpty();
                    }
                }
            } else {
                this.softAssertions.assertThat((Object)actualProperty).isExactlyInstanceOf(expectedProperty.getClass());
            }
        }
    }

    private void validateOperation(Operation actualOperation, Operation expectedOperation, String path, String httpMethod) {
        String message = String.format("Checking '%s' operation of path '%s'", httpMethod, path);
        if (expectedOperation != null) {
            ((ObjectAssert)this.softAssertions.assertThat((Object)actualOperation).as(message, new Object[0])).isNotNull();
            if (actualOperation != null) {
                this.validateList(actualOperation.getConsumes(), expectedOperation.getConsumes(), String.format("Checking '%s' of '%s' operation of path '%s'", "consumes", httpMethod, path));
                this.validateList(actualOperation.getProduces(), expectedOperation.getProduces(), String.format("Checking '%s' of '%s' operation of path '%s'", "produces", httpMethod, path));
                this.validateParameters(actualOperation.getParameters(), expectedOperation.getParameters(), httpMethod, path);
                this.validateResponses(actualOperation.getResponses(), expectedOperation.getResponses(), httpMethod, path);
            }
        } else {
            ((ObjectAssert)this.softAssertions.assertThat((Object)actualOperation).as(message, new Object[0])).isNull();
        }
    }

    private void validateParameters(List<Parameter> actualOperationParameters, List<Parameter> expectedOperationParameters, String httpMethod, String path) {
        String message = String.format("Checking parameters of '%s' operation of path '%s'", httpMethod, path);
        if (CollectionUtils.isNotEmpty(expectedOperationParameters)) {
            ((ListAssert)this.softAssertions.assertThat(actualOperationParameters).as(message, new Object[0])).isNotEmpty();
            if (CollectionUtils.isNotEmpty(actualOperationParameters)) {
                ((ListAssert)this.softAssertions.assertThat(actualOperationParameters).as(message, new Object[0])).hasSameSizeAs(expectedOperationParameters);
                HashMap<String, Parameter> expectedParametersAsMap = new HashMap<String, Parameter>();
                for (Parameter expectedParameter : expectedOperationParameters) {
                    expectedParametersAsMap.put(expectedParameter.getName(), expectedParameter);
                }
                for (Parameter actualParameter : actualOperationParameters) {
                    String parameterName = actualParameter.getName();
                    Parameter expectedParameter = (Parameter)expectedParametersAsMap.get(parameterName);
                    this.validateParameter(actualParameter, expectedParameter, parameterName, httpMethod, path);
                }
            }
        } else {
            ((ListAssert)this.softAssertions.assertThat(actualOperationParameters).as(message, new Object[0])).isNullOrEmpty();
        }
    }

    private void validateParameter(Parameter actualParameter, Parameter expectedParameter, String parameterName, String httpMethod, String path) {
        if (expectedParameter != null) {
            String message = String.format("Checking parameter '%s' of '%s' operation of path '%s'", parameterName, httpMethod, path);
            ((ObjectAssert)this.softAssertions.assertThat((Object)actualParameter).as(message, new Object[0])).isExactlyInstanceOf(expectedParameter.getClass());
            if (expectedParameter instanceof BodyParameter && actualParameter instanceof BodyParameter) {
                BodyParameter actualBodyParameter = (BodyParameter)expectedParameter;
                BodyParameter expectedBodyParameter = (BodyParameter)expectedParameter;
                this.validateModel(actualBodyParameter.getSchema(), expectedBodyParameter.getSchema(), String.format("Checking model of parameter '%s' of '%s' operation of path '%s'", parameterName, httpMethod, path));
            } else if (expectedParameter instanceof PathParameter && actualParameter instanceof PathParameter) {
                PathParameter actualPathParameter = (PathParameter)actualParameter;
                PathParameter expectedPathParameter = (PathParameter)expectedParameter;
                ((StringAssert)this.softAssertions.assertThat(actualPathParameter.getType()).as(message, new Object[0])).isEqualTo((Object)expectedPathParameter.getType());
                List expectedEnums = expectedPathParameter.getEnum();
                if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
                    ((ListAssert)this.softAssertions.assertThat(actualPathParameter.getEnum()).as(message, new Object[0])).hasSameElementsAs((Iterable)expectedEnums);
                } else {
                    ((ListAssert)this.softAssertions.assertThat(actualPathParameter.getEnum()).as(message, new Object[0])).isNullOrEmpty();
                }
            } else if (expectedParameter instanceof QueryParameter && actualParameter instanceof QueryParameter) {
                QueryParameter actualQueryParameter = (QueryParameter)actualParameter;
                QueryParameter expectedQueryParameter = (QueryParameter)expectedParameter;
                ((StringAssert)this.softAssertions.assertThat(actualQueryParameter.getType()).as(message, new Object[0])).isEqualTo((Object)expectedQueryParameter.getType());
                List expectedEnums = expectedQueryParameter.getEnum();
                if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
                    ((ListAssert)this.softAssertions.assertThat(actualQueryParameter.getEnum()).as(message, new Object[0])).hasSameElementsAs((Iterable)expectedEnums);
                } else {
                    ((ListAssert)this.softAssertions.assertThat(actualQueryParameter.getEnum()).as(message, new Object[0])).isNullOrEmpty();
                }
            } else if (expectedParameter instanceof HeaderParameter && actualParameter instanceof HeaderParameter) {
                HeaderParameter actualHeaderParameter = (HeaderParameter)actualParameter;
                HeaderParameter expectedHeaderParameter = (HeaderParameter)expectedParameter;
                ((StringAssert)this.softAssertions.assertThat(actualHeaderParameter.getType()).as(message, new Object[0])).isEqualTo((Object)expectedHeaderParameter.getType());
                List expectedEnums = expectedHeaderParameter.getEnum();
                if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
                    ((ListAssert)this.softAssertions.assertThat(actualHeaderParameter.getEnum()).as(message, new Object[0])).hasSameElementsAs((Iterable)expectedEnums);
                } else {
                    ((ListAssert)this.softAssertions.assertThat(actualHeaderParameter.getEnum()).as(message, new Object[0])).isNullOrEmpty();
                }
            } else if (expectedParameter instanceof FormParameter && actualParameter instanceof FormParameter) {
                FormParameter actualFormParameter = (FormParameter)actualParameter;
                FormParameter expectedFormParameter = (FormParameter)expectedParameter;
                ((StringAssert)this.softAssertions.assertThat(actualFormParameter.getType()).as(message, new Object[0])).isEqualTo((Object)expectedFormParameter.getType());
                List expectedEnums = expectedFormParameter.getEnum();
                if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
                    ((ListAssert)this.softAssertions.assertThat(actualFormParameter.getEnum()).as(message, new Object[0])).hasSameElementsAs((Iterable)expectedEnums);
                } else {
                    ((ListAssert)this.softAssertions.assertThat(actualFormParameter.getEnum()).as(message, new Object[0])).isNullOrEmpty();
                }
            } else if (expectedParameter instanceof CookieParameter && actualParameter instanceof CookieParameter) {
                CookieParameter actualCookieParameter = (CookieParameter)actualParameter;
                CookieParameter expectedCookieParameter = (CookieParameter)expectedParameter;
                ((StringAssert)this.softAssertions.assertThat(actualCookieParameter.getType()).as(message, new Object[0])).isEqualTo((Object)expectedCookieParameter.getType());
                List expectedEnums = expectedCookieParameter.getEnum();
                if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
                    ((ListAssert)this.softAssertions.assertThat(actualCookieParameter.getEnum()).as(message, new Object[0])).hasSameElementsAs((Iterable)expectedEnums);
                } else {
                    ((ListAssert)this.softAssertions.assertThat(actualCookieParameter.getEnum()).as(message, new Object[0])).isNullOrEmpty();
                }
            } else if (expectedParameter instanceof RefParameter && actualParameter instanceof RefParameter) {
                RefParameter expectedRefParameter = (RefParameter)expectedParameter;
                RefParameter actualRefParameter = (RefParameter)actualParameter;
                ((StringAssert)this.softAssertions.assertThat(actualRefParameter.getSimpleRef()).as(message, new Object[0])).isEqualTo((Object)expectedRefParameter.getSimpleRef());
            }
        }
    }

    private void validateResponses(Map<String, Response> actualOperationResponses, Map<String, Response> expectedOperationResponses, String httpMethod, String path) {
        String message = String.format("Checking responses of '%s' operation of path '%s'", httpMethod, path);
        if (MapUtils.isNotEmpty(expectedOperationResponses)) {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualOperationResponses).as(message, new Object[0])).isNotEmpty();
            if (MapUtils.isNotEmpty(actualOperationResponses)) {
                ((IterableAssert)this.softAssertions.assertThat(actualOperationResponses.keySet()).as(message, new Object[0])).hasSameElementsAs(expectedOperationResponses.keySet());
                for (Map.Entry<String, Response> actualResponseEntry : actualOperationResponses.entrySet()) {
                    Response expectedResponse = expectedOperationResponses.get(actualResponseEntry.getKey());
                    Response actualResponse = actualResponseEntry.getValue();
                    String responseName = actualResponseEntry.getKey();
                    this.validateResponse(actualResponse, expectedResponse, responseName, httpMethod, path);
                }
            }
        } else {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualOperationResponses).as(message, new Object[0])).isNullOrEmpty();
        }
    }

    private void validateResponse(Response actualResponse, Response expectedResponse, String responseName, String httpMethod, String path) {
        if (expectedResponse != null) {
            this.validateProperty(actualResponse.getSchema(), expectedResponse.getSchema(), String.format("Checking response schema of response '%s' of '%s' operation of path '%s'", responseName, httpMethod, path));
            this.validateResponseHeaders(actualResponse.getHeaders(), expectedResponse.getHeaders(), responseName, httpMethod, path);
        }
    }

    private void validateResponseHeaders(Map<String, Property> actualResponseHeaders, Map<String, Property> expectedResponseHeaders, String responseName, String httpMethod, String path) {
        String message = String.format("Checking response headers of response '%s' of '%s' operation of path '%s'", responseName, httpMethod, path);
        if (MapUtils.isNotEmpty(expectedResponseHeaders)) {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualResponseHeaders).as(message, new Object[0])).isNotEmpty();
            if (MapUtils.isNotEmpty(actualResponseHeaders)) {
                ((IterableAssert)this.softAssertions.assertThat(actualResponseHeaders.keySet()).as(message, new Object[0])).hasSameElementsAs(expectedResponseHeaders.keySet());
                for (Map.Entry<String, Property> actualResponseHeaderEntry : actualResponseHeaders.entrySet()) {
                    Property expectedResponseHeader = expectedResponseHeaders.get(actualResponseHeaderEntry.getKey());
                    Property actualResponseHeader = actualResponseHeaderEntry.getValue();
                    String responseHeaderName = actualResponseHeaderEntry.getKey();
                    this.validateProperty(actualResponseHeader, expectedResponseHeader, String.format("Checking response header '%s' of response '%s' of '%s' operation of path '%s'", responseHeaderName, responseName, httpMethod, path));
                }
            }
        } else {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualResponseHeaders).as(message, new Object[0])).isNullOrEmpty();
        }
    }

    private void validateList(List<String> actualList, List<String> expectedList, String message) {
        if (CollectionUtils.isNotEmpty(expectedList)) {
            ((ListAssert)this.softAssertions.assertThat(actualList).as(message, new Object[0])).isNotEmpty();
            if (CollectionUtils.isNotEmpty(actualList)) {
                ((ListAssert)this.softAssertions.assertThat(actualList).as(message, new Object[0])).hasSameElementsAs(expectedList);
            }
        } else {
            ((ListAssert)this.softAssertions.assertThat(actualList).as(message, new Object[0])).isNullOrEmpty();
        }
    }
}

