/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger.test;

import io.github.robwin.swagger.test.SwaggerAssertionConfig;
import io.github.robwin.swagger.test.SwaggerAssertionType;
import io.swagger.models.ArrayModel;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.parameters.RefParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.parser.SwaggerParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertionMapAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.StringAssert;

public class SwaggerAssert
extends AbstractAssert<SwaggerAssert, Swagger> {
    private SoftAssertions softAssertions = new SoftAssertions();
    private static final String ASSERTION_ENABLED_CONFIG_PATH = "/assertj-swagger.properties";
    private SwaggerAssertionConfig assertionConfig = this.loadSwaggerAssertionFlagsConfiguration("/assertj-swagger.properties");
    private AttributeResolver attributeResolver;

    public SwaggerAssert(Swagger actual) {
        super((Object)actual, SwaggerAssert.class);
    }

    public SwaggerAssert(Swagger actual, SwaggerAssertionConfig assertionConfig) {
        this(actual);
        this.assertionConfig = assertionConfig;
    }

    public SwaggerAssert(Swagger actual, String configurationResourceLocation) {
        this(actual);
        this.assertionConfig = this.loadSwaggerAssertionFlagsConfiguration(configurationResourceLocation);
    }

    public SwaggerAssert isEqualTo(Swagger expected) {
        this.attributeResolver = new AttributeResolver(expected, (Swagger)this.actual);
        this.validateSwagger(expected);
        return (SwaggerAssert)this.myself;
    }

    public SwaggerAssert isEqualTo(String expectedLocation) {
        return this.isEqualTo(new SwaggerParser().read(expectedLocation));
    }

    private void validateSwagger(Swagger expected) {
        Set<String> filter;
        this.validateInfo(((Swagger)this.actual).getInfo(), expected.getInfo());
        if (this.isAssertionEnabled(SwaggerAssertionType.PATHS)) {
            filter = this.assertionConfig.getPathsToIgnoreInExpected();
            Map<String, Path> expectedPaths = this.adjustExpectedPathsWithPrefix(expected.getPaths(), this.assertionConfig.getPathsPrependExpected());
            this.validatePaths(((Swagger)this.actual).getPaths(), this.removeAllFromMap(expectedPaths, filter));
        }
        if (this.isAssertionEnabled(SwaggerAssertionType.DEFINITIONS)) {
            filter = this.assertionConfig.getDefinitionsToIgnoreInExpected();
            this.validateDefinitions(((Swagger)this.actual).getDefinitions(), this.removeAllFromMap(expected.getDefinitions(), filter));
        }
        this.softAssertions.assertAll();
    }

    private void validateInfo(Info actualInfo, Info expectedInfo) {
        if (this.isAssertionEnabled(SwaggerAssertionType.VERSION)) {
            ((StringAssert)this.softAssertions.assertThat(actualInfo.getVersion()).as("Checking Version", new Object[0])).isEqualTo((Object)expectedInfo.getVersion());
        }
        if (this.isAssertionEnabled(SwaggerAssertionType.INFO)) {
            ((ObjectAssert)this.softAssertions.assertThat((Object)actualInfo).as("Checking Info", new Object[0])).isEqualToComparingFieldByField((Object)expectedInfo);
        }
    }

    private void validatePaths(Map<String, Path> actualPaths, Map<String, Path> expectedPaths) {
        if (MapUtils.isNotEmpty(expectedPaths)) {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualPaths).as("Checking Paths", new Object[0])).isNotEmpty();
            if (MapUtils.isNotEmpty(actualPaths)) {
                ((IterableAssert)this.softAssertions.assertThat(actualPaths.keySet()).as("Checking Paths", new Object[0])).hasSameElementsAs(expectedPaths.keySet());
                for (Map.Entry<String, Path> actualPathEntry : actualPaths.entrySet()) {
                    Path expectedPath = expectedPaths.get(actualPathEntry.getKey());
                    Path actualPath = actualPathEntry.getValue();
                    String pathName = actualPathEntry.getKey();
                    this.validatePath(pathName, actualPath, expectedPath);
                }
            }
        } else {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualPaths).as("Checking Paths", new Object[0])).isNullOrEmpty();
        }
    }

    private void validateDefinitions(Map<String, Model> actualDefinitions, Map<String, Model> expectedDefinitions) {
        if (MapUtils.isNotEmpty(expectedDefinitions)) {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualDefinitions).as("Checking Definitions", new Object[0])).isNotEmpty();
            if (MapUtils.isNotEmpty(actualDefinitions)) {
                ((IterableAssert)this.softAssertions.assertThat(actualDefinitions.keySet()).as("Checking Definitions", new Object[0])).hasSameElementsAs(expectedDefinitions.keySet());
                for (Map.Entry<String, Model> actualDefinitionEntry : actualDefinitions.entrySet()) {
                    Model expectedDefinition = expectedDefinitions.get(actualDefinitionEntry.getKey());
                    Model actualDefinition = actualDefinitionEntry.getValue();
                    String definitionName = actualDefinitionEntry.getKey();
                    this.validateDefinition(definitionName, actualDefinition, expectedDefinition);
                }
            }
        } else {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualDefinitions).as("Checking Definitions", new Object[0])).isNullOrEmpty();
        }
    }

    private void validatePath(String pathName, Path actualPath, Path expectedPath) {
        if (expectedPath != null) {
            ((ListAssert)this.softAssertions.assertThat(actualPath.getOperations()).as("Checking number of operations of path '%s'", new Object[]{pathName})).hasSameSizeAs((Iterable)actualPath.getOperations());
            this.validateOperation(actualPath.getGet(), expectedPath.getGet(), pathName, "GET");
            this.validateOperation(actualPath.getDelete(), expectedPath.getDelete(), pathName, "DELETE");
            this.validateOperation(actualPath.getPost(), expectedPath.getPost(), pathName, "POST");
            this.validateOperation(actualPath.getPut(), expectedPath.getPut(), pathName, "PUT");
            this.validateOperation(actualPath.getPatch(), expectedPath.getPatch(), pathName, "PATCH");
            this.validateOperation(actualPath.getOptions(), expectedPath.getOptions(), pathName, "OPTIONS");
        }
    }

    private void validateDefinition(String definitionName, Model actualDefinition, Model expectedDefinition) {
        if (expectedDefinition != null) {
            this.validateModel(actualDefinition, expectedDefinition, String.format("Checking model of definition '%s", definitionName));
            this.validateDefinitionProperties(actualDefinition.getProperties(), expectedDefinition.getProperties(), definitionName);
        }
    }

    private void validateModel(Model actualDefinition, Model expectedDefinition, String message) {
        if (this.isAssertionEnabled(SwaggerAssertionType.MODELS)) {
            if (expectedDefinition instanceof ModelImpl) {
                ((ObjectAssert)this.softAssertions.assertThat((Object)actualDefinition).as(message, new Object[0])).isExactlyInstanceOf(ModelImpl.class);
            } else if (expectedDefinition instanceof RefModel) {
                ((ObjectAssert)this.softAssertions.assertThat((Object)actualDefinition).as(message, new Object[0])).isExactlyInstanceOf(RefModel.class);
            } else if (expectedDefinition instanceof ArrayModel) {
                ArrayModel arrayModel = (ArrayModel)expectedDefinition;
                ((ObjectAssert)this.softAssertions.assertThat((Object)actualDefinition).as(message, new Object[0])).isExactlyInstanceOf(ArrayModel.class);
            } else {
                this.softAssertions.assertThat((Object)actualDefinition).isExactlyInstanceOf(expectedDefinition.getClass());
            }
        }
    }

    private void validateDefinitionProperties(Map<String, Property> actualDefinitionProperties, Map<String, Property> expectedDefinitionProperties, String definitionName) {
        if (MapUtils.isNotEmpty(expectedDefinitionProperties)) {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualDefinitionProperties).as("Checking properties of definition '%s", new Object[]{definitionName})).isNotEmpty();
            if (MapUtils.isNotEmpty(actualDefinitionProperties)) {
                Set<String> filteredExpectedProperties = this.filterWhitelistedPropertyNames(definitionName, expectedDefinitionProperties.keySet());
                ((IterableAssert)this.softAssertions.assertThat(actualDefinitionProperties.keySet()).as("Checking properties of definition '%s'", new Object[]{definitionName})).hasSameElementsAs(filteredExpectedProperties);
                for (Map.Entry<String, Property> actualDefinitionPropertyEntry : actualDefinitionProperties.entrySet()) {
                    Property expectedDefinitionProperty = expectedDefinitionProperties.get(actualDefinitionPropertyEntry.getKey());
                    Property actualDefinitionProperty = actualDefinitionPropertyEntry.getValue();
                    String propertyName = actualDefinitionPropertyEntry.getKey();
                    this.validateProperty(actualDefinitionProperty, expectedDefinitionProperty, String.format("Checking property '%s' of definition '%s'", propertyName, definitionName));
                }
            }
        } else {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualDefinitionProperties).as("Checking properties of definition '%s", new Object[]{definitionName})).isNullOrEmpty();
        }
    }

    private void validateProperty(Property actualProperty, Property expectedProperty, String message) {
        if (expectedProperty != null && this.isAssertionEnabled(SwaggerAssertionType.PROPERTIES)) {
            if (expectedProperty instanceof RefProperty) {
                if (this.isAssertionEnabled(SwaggerAssertionType.REF_PROPERTIES)) {
                    RefProperty refProperty = (RefProperty)expectedProperty;
                    ((ObjectAssert)this.softAssertions.assertThat((Object)actualProperty).as(message, new Object[0])).isExactlyInstanceOf(RefProperty.class);
                }
            } else if (expectedProperty instanceof ArrayProperty) {
                if (this.isAssertionEnabled(SwaggerAssertionType.ARRAY_PROPERTIES)) {
                    ArrayProperty arrayProperty = (ArrayProperty)expectedProperty;
                    ((ObjectAssert)this.softAssertions.assertThat((Object)actualProperty).as(message, new Object[0])).isExactlyInstanceOf(ArrayProperty.class);
                }
            } else if (expectedProperty instanceof StringProperty) {
                if (this.isAssertionEnabled(SwaggerAssertionType.STRING_PROPERTIES)) {
                    StringProperty expectedStringProperty = (StringProperty)expectedProperty;
                    ((ObjectAssert)this.softAssertions.assertThat((Object)actualProperty).as(message, new Object[0])).isExactlyInstanceOf(StringProperty.class);
                    if (actualProperty instanceof StringProperty) {
                        StringProperty actualStringProperty = (StringProperty)expectedProperty;
                        List expectedEnums = expectedStringProperty.getEnum();
                        if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
                            this.softAssertions.assertThat(actualStringProperty.getEnum()).hasSameElementsAs((Iterable)expectedEnums);
                        } else {
                            this.softAssertions.assertThat(actualStringProperty.getEnum()).isNullOrEmpty();
                        }
                    }
                }
            } else {
                this.softAssertions.assertThat((Object)actualProperty).isExactlyInstanceOf(expectedProperty.getClass());
            }
        }
    }

    private void validateOperation(Operation actualOperation, Operation expectedOperation, String path, String httpMethod) {
        String message = String.format("Checking '%s' operation of path '%s'", httpMethod, path);
        if (expectedOperation != null) {
            ((ObjectAssert)this.softAssertions.assertThat((Object)actualOperation).as(message, new Object[0])).isNotNull();
            if (actualOperation != null) {
                this.validateList(this.attributeResolver.getActualConsumes(actualOperation), this.attributeResolver.getExpectedConsumes(expectedOperation), String.format("Checking '%s' of '%s' operation of path '%s'", "consumes", httpMethod, path));
                this.validateList(this.attributeResolver.getActualProduces(actualOperation), this.attributeResolver.getExpectedProduces(expectedOperation), String.format("Checking '%s' of '%s' operation of path '%s'", "produces", httpMethod, path));
                this.validateParameters(actualOperation.getParameters(), expectedOperation.getParameters(), httpMethod, path);
                this.validateResponses(actualOperation.getResponses(), expectedOperation.getResponses(), httpMethod, path);
            }
        } else {
            ((ObjectAssert)this.softAssertions.assertThat((Object)actualOperation).as(message, new Object[0])).isNull();
        }
    }

    private void validateParameters(List<Parameter> actualOperationParameters, List<Parameter> expectedOperationParameters, String httpMethod, String path) {
        String message = String.format("Checking parameters of '%s' operation of path '%s'", httpMethod, path);
        if (CollectionUtils.isNotEmpty(expectedOperationParameters)) {
            ((ListAssert)this.softAssertions.assertThat(actualOperationParameters).as(message, new Object[0])).isNotEmpty();
            if (CollectionUtils.isNotEmpty(actualOperationParameters)) {
                ((ListAssert)this.softAssertions.assertThat(actualOperationParameters).as(message, new Object[0])).hasSameSizeAs(expectedOperationParameters);
                HashMap<String, Parameter> expectedParametersAsMap = new HashMap<String, Parameter>();
                for (Parameter expectedParameter : expectedOperationParameters) {
                    expectedParametersAsMap.put(expectedParameter.getName(), expectedParameter);
                }
                for (Parameter actualParameter : actualOperationParameters) {
                    String parameterName = actualParameter.getName();
                    Parameter expectedParameter = (Parameter)expectedParametersAsMap.get(parameterName);
                    this.validateParameter(actualParameter, expectedParameter, parameterName, httpMethod, path);
                }
            }
        } else {
            ((ListAssert)this.softAssertions.assertThat(actualOperationParameters).as(message, new Object[0])).isNullOrEmpty();
        }
    }

    private void validateParameter(Parameter actualParameter, Parameter expectedParameter, String parameterName, String httpMethod, String path) {
        if (expectedParameter != null) {
            String message = String.format("Checking parameter '%s' of '%s' operation of path '%s'", parameterName, httpMethod, path);
            ((ObjectAssert)this.softAssertions.assertThat((Object)actualParameter).as(message, new Object[0])).isExactlyInstanceOf(expectedParameter.getClass());
            if (expectedParameter instanceof BodyParameter && actualParameter instanceof BodyParameter) {
                BodyParameter actualBodyParameter = (BodyParameter)expectedParameter;
                BodyParameter expectedBodyParameter = (BodyParameter)expectedParameter;
                this.validateModel(actualBodyParameter.getSchema(), expectedBodyParameter.getSchema(), String.format("Checking model of parameter '%s' of '%s' operation of path '%s'", parameterName, httpMethod, path));
            } else if (expectedParameter instanceof PathParameter && actualParameter instanceof PathParameter) {
                PathParameter actualPathParameter = (PathParameter)actualParameter;
                PathParameter expectedPathParameter = (PathParameter)expectedParameter;
                ((StringAssert)this.softAssertions.assertThat(actualPathParameter.getType()).as(message, new Object[0])).isEqualTo((Object)expectedPathParameter.getType());
                List expectedEnums = expectedPathParameter.getEnum();
                if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
                    ((ListAssert)this.softAssertions.assertThat(actualPathParameter.getEnum()).as(message, new Object[0])).hasSameElementsAs((Iterable)expectedEnums);
                } else {
                    ((ListAssert)this.softAssertions.assertThat(actualPathParameter.getEnum()).as(message, new Object[0])).isNullOrEmpty();
                }
            } else if (expectedParameter instanceof QueryParameter && actualParameter instanceof QueryParameter) {
                QueryParameter actualQueryParameter = (QueryParameter)actualParameter;
                QueryParameter expectedQueryParameter = (QueryParameter)expectedParameter;
                ((StringAssert)this.softAssertions.assertThat(actualQueryParameter.getType()).as(message, new Object[0])).isEqualTo((Object)expectedQueryParameter.getType());
                List expectedEnums = expectedQueryParameter.getEnum();
                if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
                    ((ListAssert)this.softAssertions.assertThat(actualQueryParameter.getEnum()).as(message, new Object[0])).hasSameElementsAs((Iterable)expectedEnums);
                } else {
                    ((ListAssert)this.softAssertions.assertThat(actualQueryParameter.getEnum()).as(message, new Object[0])).isNullOrEmpty();
                }
            } else if (expectedParameter instanceof HeaderParameter && actualParameter instanceof HeaderParameter) {
                HeaderParameter actualHeaderParameter = (HeaderParameter)actualParameter;
                HeaderParameter expectedHeaderParameter = (HeaderParameter)expectedParameter;
                ((StringAssert)this.softAssertions.assertThat(actualHeaderParameter.getType()).as(message, new Object[0])).isEqualTo((Object)expectedHeaderParameter.getType());
                List expectedEnums = expectedHeaderParameter.getEnum();
                if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
                    ((ListAssert)this.softAssertions.assertThat(actualHeaderParameter.getEnum()).as(message, new Object[0])).hasSameElementsAs((Iterable)expectedEnums);
                } else {
                    ((ListAssert)this.softAssertions.assertThat(actualHeaderParameter.getEnum()).as(message, new Object[0])).isNullOrEmpty();
                }
            } else if (expectedParameter instanceof FormParameter && actualParameter instanceof FormParameter) {
                FormParameter actualFormParameter = (FormParameter)actualParameter;
                FormParameter expectedFormParameter = (FormParameter)expectedParameter;
                ((StringAssert)this.softAssertions.assertThat(actualFormParameter.getType()).as(message, new Object[0])).isEqualTo((Object)expectedFormParameter.getType());
                List expectedEnums = expectedFormParameter.getEnum();
                if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
                    ((ListAssert)this.softAssertions.assertThat(actualFormParameter.getEnum()).as(message, new Object[0])).hasSameElementsAs((Iterable)expectedEnums);
                } else {
                    ((ListAssert)this.softAssertions.assertThat(actualFormParameter.getEnum()).as(message, new Object[0])).isNullOrEmpty();
                }
            } else if (expectedParameter instanceof CookieParameter && actualParameter instanceof CookieParameter) {
                CookieParameter actualCookieParameter = (CookieParameter)actualParameter;
                CookieParameter expectedCookieParameter = (CookieParameter)expectedParameter;
                ((StringAssert)this.softAssertions.assertThat(actualCookieParameter.getType()).as(message, new Object[0])).isEqualTo((Object)expectedCookieParameter.getType());
                List expectedEnums = expectedCookieParameter.getEnum();
                if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
                    ((ListAssert)this.softAssertions.assertThat(actualCookieParameter.getEnum()).as(message, new Object[0])).hasSameElementsAs((Iterable)expectedEnums);
                } else {
                    ((ListAssert)this.softAssertions.assertThat(actualCookieParameter.getEnum()).as(message, new Object[0])).isNullOrEmpty();
                }
            } else if (expectedParameter instanceof RefParameter && actualParameter instanceof RefParameter) {
                RefParameter expectedRefParameter = (RefParameter)expectedParameter;
                RefParameter actualRefParameter = (RefParameter)actualParameter;
                ((StringAssert)this.softAssertions.assertThat(actualRefParameter.getSimpleRef()).as(message, new Object[0])).isEqualTo((Object)expectedRefParameter.getSimpleRef());
            }
        }
    }

    private void validateResponses(Map<String, Response> actualOperationResponses, Map<String, Response> expectedOperationResponses, String httpMethod, String path) {
        String message = String.format("Checking responses of '%s' operation of path '%s'", httpMethod, path);
        if (MapUtils.isNotEmpty(expectedOperationResponses)) {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualOperationResponses).as(message, new Object[0])).isNotEmpty();
            if (MapUtils.isNotEmpty(actualOperationResponses)) {
                ((IterableAssert)this.softAssertions.assertThat(actualOperationResponses.keySet()).as(message, new Object[0])).hasSameElementsAs(expectedOperationResponses.keySet());
                for (Map.Entry<String, Response> actualResponseEntry : actualOperationResponses.entrySet()) {
                    Response expectedResponse = expectedOperationResponses.get(actualResponseEntry.getKey());
                    Response actualResponse = actualResponseEntry.getValue();
                    String responseName = actualResponseEntry.getKey();
                    this.validateResponse(actualResponse, expectedResponse, responseName, httpMethod, path);
                }
            }
        } else {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualOperationResponses).as(message, new Object[0])).isNullOrEmpty();
        }
    }

    private void validateResponse(Response actualResponse, Response expectedResponse, String responseName, String httpMethod, String path) {
        if (expectedResponse != null) {
            this.validateProperty(actualResponse.getSchema(), expectedResponse.getSchema(), String.format("Checking response schema of response '%s' of '%s' operation of path '%s'", responseName, httpMethod, path));
            this.validateResponseHeaders(actualResponse.getHeaders(), expectedResponse.getHeaders(), responseName, httpMethod, path);
        }
    }

    private void validateResponseHeaders(Map<String, Property> actualResponseHeaders, Map<String, Property> expectedResponseHeaders, String responseName, String httpMethod, String path) {
        String message = String.format("Checking response headers of response '%s' of '%s' operation of path '%s'", responseName, httpMethod, path);
        if (MapUtils.isNotEmpty(expectedResponseHeaders)) {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualResponseHeaders).as(message, new Object[0])).isNotEmpty();
            if (MapUtils.isNotEmpty(actualResponseHeaders)) {
                ((IterableAssert)this.softAssertions.assertThat(actualResponseHeaders.keySet()).as(message, new Object[0])).hasSameElementsAs(expectedResponseHeaders.keySet());
                for (Map.Entry<String, Property> actualResponseHeaderEntry : actualResponseHeaders.entrySet()) {
                    Property expectedResponseHeader = expectedResponseHeaders.get(actualResponseHeaderEntry.getKey());
                    Property actualResponseHeader = actualResponseHeaderEntry.getValue();
                    String responseHeaderName = actualResponseHeaderEntry.getKey();
                    this.validateProperty(actualResponseHeader, expectedResponseHeader, String.format("Checking response header '%s' of response '%s' of '%s' operation of path '%s'", responseHeaderName, responseName, httpMethod, path));
                }
            }
        } else {
            ((SoftAssertionMapAssert)this.softAssertions.assertThat(actualResponseHeaders).as(message, new Object[0])).isNullOrEmpty();
        }
    }

    private void validateList(List<String> actualList, List<String> expectedList, String message) {
        if (CollectionUtils.isNotEmpty(expectedList)) {
            ((ListAssert)this.softAssertions.assertThat(actualList).as(message, new Object[0])).isNotEmpty();
            if (CollectionUtils.isNotEmpty(actualList)) {
                ((ListAssert)this.softAssertions.assertThat(actualList).as(message, new Object[0])).hasSameElementsAs(expectedList);
            }
        } else {
            ((ListAssert)this.softAssertions.assertThat(actualList).as(message, new Object[0])).isNullOrEmpty();
        }
    }

    private SwaggerAssertionConfig loadSwaggerAssertionFlagsConfiguration(String configurationResourceLocation) {
        Properties props = new Properties();
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(configurationResourceLocation);){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new SwaggerAssertionConfig(props);
    }

    private boolean isAssertionEnabled(SwaggerAssertionType assertionType) {
        return this.assertionConfig.swaggerAssertionEnabled(assertionType);
    }

    private Set<String> filterWhitelistedPropertyNames(String definitionName, Set<String> expectedPropertyNames) {
        HashSet<String> result = new HashSet<String>(expectedPropertyNames.size());
        Set<String> ignoredPropertyNames = this.assertionConfig.getPropertiesToIgnoreInExpected();
        for (String property : expectedPropertyNames) {
            if (ignoredPropertyNames.contains(definitionName + '.' + property)) continue;
            result.add(property);
        }
        return result;
    }

    private <K, V> Map<K, V> removeAllFromMap(Map<K, V> map, Set<K> keysToExclude) {
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>(map);
        result.keySet().removeAll(keysToExclude);
        return result;
    }

    private Map<String, Path> adjustExpectedPathsWithPrefix(Map<String, Path> paths, String prefix) {
        if (StringUtils.isBlank((CharSequence)prefix)) {
            return paths;
        }
        HashMap<String, Path> adjustedPaths = new HashMap<String, Path>(paths.size());
        for (Map.Entry<String, Path> entry : paths.entrySet()) {
            adjustedPaths.put(prefix + entry.getKey(), entry.getValue());
        }
        return adjustedPaths;
    }

    private class AttributeResolver {
        private Swagger expected;
        private Swagger actual;

        public AttributeResolver(Swagger expected, Swagger actual) {
            this.expected = expected;
            this.actual = actual;
        }

        public List<String> getExpectedConsumes(Operation op) {
            return this.getListWithFallback(op.getConsumes(), this.expected.getConsumes());
        }

        public List<String> getActualConsumes(Operation op) {
            return this.getListWithFallback(op.getConsumes(), this.actual.getConsumes());
        }

        public List<String> getExpectedProduces(Operation op) {
            return this.getListWithFallback(op.getProduces(), this.expected.getProduces());
        }

        public List<String> getActualProduces(Operation op) {
            return this.getListWithFallback(op.getProduces(), this.actual.getProduces());
        }

        private <A> List<A> getListWithFallback(List<A> localDefn, List<A> globalDefn) {
            List<Object> result = localDefn != null && !localDefn.isEmpty() ? localDefn : (globalDefn != null ? globalDefn : Collections.emptyList());
            return result;
        }
    }
}

