/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger2markup.builder.document;

import com.google.common.collect.ImmutableMap;
import io.github.robwin.markup.builder.MarkupDocBuilder;
import io.github.robwin.markup.builder.MarkupDocBuilders;
import io.github.robwin.markup.builder.MarkupLanguage;
import io.github.robwin.swagger2markup.OrderBy;
import io.github.robwin.swagger2markup.builder.document.MarkupDocument;
import io.github.robwin.swagger2markup.config.Swagger2MarkupConfig;
import io.github.robwin.swagger2markup.utils.PropertyUtils;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.RefModel;
import io.swagger.models.properties.Property;
import io.swagger.models.refs.RefFormat;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class DefinitionsDocument
extends MarkupDocument {
    private static final String DEFINITIONS = "Definitions";
    private static final List<String> IGNORED_DEFINITIONS = Collections.singletonList("Void");
    private static final String JSON_SCHEMA = "JSON Schema";
    private static final String XML_SCHEMA = "XML Schema";
    private static final String JSON_SCHEMA_EXTENSION = ".json";
    private static final String XML_SCHEMA_EXTENSION = ".xsd";
    private static final String JSON = "json";
    private static final String XML = "xml";
    private static final String DESCRIPTION_FILE_NAME = "description";
    private boolean schemasEnabled;
    private String schemasFolderPath;
    private boolean handWrittenDescriptionsEnabled;
    private String descriptionsFolderPath;
    private boolean separatedDefinitionsEnabled;
    private String outputDirectory;
    private final OrderBy definitionsOrderedBy;

    public DefinitionsDocument(Swagger2MarkupConfig swagger2MarkupConfig, String outputDirectory) {
        super(swagger2MarkupConfig);
        this.definitionsOrderedBy = swagger2MarkupConfig.getDefinitionsOrderedBy();
        if (StringUtils.isNotBlank((CharSequence)swagger2MarkupConfig.getSchemasFolderPath())) {
            this.schemasEnabled = true;
            this.schemasFolderPath = swagger2MarkupConfig.getSchemasFolderPath();
        }
        if (StringUtils.isNotBlank((CharSequence)swagger2MarkupConfig.getDescriptionsFolderPath())) {
            this.handWrittenDescriptionsEnabled = true;
            this.descriptionsFolderPath = swagger2MarkupConfig.getDescriptionsFolderPath() + "/" + DEFINITIONS.toLowerCase();
        }
        if (this.schemasEnabled) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Include schemas is enabled.");
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Include schemas is disabled.");
        }
        if (this.handWrittenDescriptionsEnabled) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Include hand-written descriptions is enabled.");
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Include hand-written descriptions is disabled.");
        }
        this.separatedDefinitionsEnabled = swagger2MarkupConfig.isSeparatedDefinitions();
        if (this.separatedDefinitionsEnabled) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Create separated definition files is enabled.");
            }
            Validate.notEmpty((CharSequence)outputDirectory, (String)"Output directory is required for separated definition files!", (Object[])new Object[0]);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Create separated definition files is disabled.");
        }
        this.outputDirectory = outputDirectory;
    }

    @Override
    public MarkupDocument build() {
        this.definitions(this.swagger.getDefinitions(), this.markupDocBuilder);
        return this;
    }

    private void definitions(Map<String, Model> definitions, MarkupDocBuilder docBuilder) {
        if (MapUtils.isNotEmpty(definitions)) {
            docBuilder.sectionTitleLevel1(DEFINITIONS);
            Set<String> definitionNames = this.definitionsOrderedBy.equals((Object)OrderBy.AS_IS) ? definitions.keySet() : new TreeSet<String>(definitions.keySet());
            for (String definitionName : definitionNames) {
                Model model = definitions.get(definitionName);
                if (!StringUtils.isNotBlank((CharSequence)definitionName)) continue;
                if (this.checkThatDefinitionIsNotInIgnoreList(definitionName)) {
                    this.definition(definitions, definitionName, model, docBuilder);
                    this.definitionSchema(definitionName, docBuilder);
                    if (this.separatedDefinitionsEnabled) {
                        block7: {
                            MarkupDocBuilder defDocBuilder = MarkupDocBuilders.documentBuilder((MarkupLanguage)this.markupLanguage);
                            this.definition(definitions, definitionName, model, defDocBuilder);
                            this.definitionSchema(definitionName, defDocBuilder);
                            try {
                                defDocBuilder.writeToFile(this.outputDirectory, definitionName.toLowerCase(), StandardCharsets.UTF_8);
                            }
                            catch (IOException e) {
                                if (!this.logger.isWarnEnabled()) break block7;
                                this.logger.warn(String.format("Failed to write definition file: %s", definitionName), (Throwable)e);
                            }
                        }
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("Separate definition file produced: {}", (Object)definitionName);
                        }
                    }
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info("Definition processed: {}", (Object)definitionName);
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Definition was ignored: {}", (Object)definitionName);
            }
        }
    }

    private boolean checkThatDefinitionIsNotInIgnoreList(String definitionName) {
        return !IGNORED_DEFINITIONS.contains(definitionName);
    }

    private void definition(Map<String, Model> definitions, String definitionName, Model model, MarkupDocBuilder docBuilder) {
        docBuilder.sectionTitleLevel2(definitionName);
        this.descriptionSection(definitionName, model, docBuilder);
        this.propertiesSection(definitions, definitionName, model, docBuilder);
    }

    private void propertiesSection(Map<String, Model> definitions, String definitionName, Model model, MarkupDocBuilder docBuilder) {
        Map<String, Property> properties = this.getAllProperties(definitions, model);
        ArrayList<String> headerAndContent = new ArrayList<String>();
        List<String> header = Arrays.asList("Name", "Description", "Required", "Schema", "Default");
        headerAndContent.add(StringUtils.join(header, (String)"|"));
        if (MapUtils.isNotEmpty(properties)) {
            for (Map.Entry<String, Property> propertyEntry : properties.entrySet()) {
                Property property = propertyEntry.getValue();
                String propertyName = propertyEntry.getKey();
                List<String> content = Arrays.asList(propertyName, this.propertyDescription(definitionName, propertyName, property), Boolean.toString(property.getRequired()), PropertyUtils.getType(property, this.markupLanguage), PropertyUtils.getDefaultValue(property));
                headerAndContent.add(StringUtils.join(content, (String)"|"));
            }
            docBuilder.tableWithHeaderRow(headerAndContent);
        }
    }

    private Map<String, Property> getAllProperties(Map<String, Model> definitions, Model model) {
        if (model instanceof RefModel) {
            RefModel refModel = (RefModel)model;
            String ref = refModel.getRefFormat().equals((Object)RefFormat.INTERNAL) ? refModel.getSimpleRef() : model.getReference();
            return definitions.containsKey(ref) ? this.getAllProperties(definitions, definitions.get(ref)) : null;
        }
        if (model instanceof ComposedModel) {
            ComposedModel composedModel = (ComposedModel)model;
            ImmutableMap.Builder allProperties = ImmutableMap.builder();
            if (composedModel.getAllOf() != null) {
                for (Model innerModel : composedModel.getAllOf()) {
                    Map<String, Property> innerProperties = this.getAllProperties(definitions, innerModel);
                    if (innerProperties == null) continue;
                    allProperties.putAll(innerProperties);
                }
            }
            return allProperties.build();
        }
        return model.getProperties();
    }

    private void descriptionSection(String definitionName, Model model, MarkupDocBuilder docBuilder) {
        if (this.handWrittenDescriptionsEnabled) {
            String description = this.handWrittenPathDescription(definitionName.toLowerCase(), DESCRIPTION_FILE_NAME);
            if (StringUtils.isNotBlank((CharSequence)description)) {
                docBuilder.paragraph(description);
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Hand-written description cannot be read. Trying to use description from Swagger source.");
                }
                this.modelDescription(model, docBuilder);
            }
        } else {
            this.modelDescription(model, docBuilder);
        }
    }

    private void modelDescription(Model model, MarkupDocBuilder docBuilder) {
        String description = model.getDescription();
        if (StringUtils.isNotBlank((CharSequence)description)) {
            docBuilder.paragraph(description);
        }
    }

    private String propertyDescription(String definitionName, String propertyName, Property property) {
        String description;
        if (this.handWrittenDescriptionsEnabled) {
            description = this.handWrittenPathDescription(definitionName.toLowerCase() + "/" + propertyName.toLowerCase(), DESCRIPTION_FILE_NAME);
            if (StringUtils.isBlank((CharSequence)description)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Hand-written description file cannot be read. Trying to use description from Swagger source.");
                }
                description = StringUtils.defaultString((String)property.getDescription());
            }
        } else {
            description = StringUtils.defaultString((String)property.getDescription());
        }
        return description;
    }

    private String handWrittenPathDescription(String descriptionFolder, String descriptionFileName) {
        for (String fileNameExtension : this.markupLanguage.getFileNameExtensions()) {
            Path path = Paths.get(this.descriptionsFolderPath, descriptionFolder, descriptionFileName + fileNameExtension);
            if (Files.isReadable(path)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Description file processed: {}", (Object)path);
                }
                try {
                    return FileUtils.readFileToString((File)path.toFile(), (Charset)StandardCharsets.UTF_8).trim();
                }
                catch (IOException e) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn(String.format("Failed to read description file: %s", path), (Throwable)e);
                    continue;
                }
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Description file is not readable: {}", (Object)path);
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.info("No description file found with correct file name extension in folder: {}", (Object)Paths.get(this.descriptionsFolderPath, descriptionFolder));
        }
        return null;
    }

    private void definitionSchema(String definitionName, MarkupDocBuilder docBuilder) {
        if (this.schemasEnabled && StringUtils.isNotBlank((CharSequence)definitionName)) {
            this.schema(JSON_SCHEMA, this.schemasFolderPath, definitionName + JSON_SCHEMA_EXTENSION, JSON, docBuilder);
            this.schema(XML_SCHEMA, this.schemasFolderPath, definitionName + XML_SCHEMA_EXTENSION, XML, docBuilder);
        }
    }

    private void schema(String title, String schemasFolderPath, String schemaName, String language, MarkupDocBuilder docBuilder) {
        Path path = Paths.get(schemasFolderPath, schemaName);
        if (Files.isReadable(path)) {
            block6: {
                docBuilder.sectionTitleLevel3(title);
                try {
                    docBuilder.source(FileUtils.readFileToString((File)path.toFile(), (Charset)StandardCharsets.UTF_8).trim(), language);
                }
                catch (IOException e) {
                    if (!this.logger.isWarnEnabled()) break block6;
                    this.logger.warn(String.format("Failed to read schema file: %s", path), (Throwable)e);
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Schema file processed: {}", (Object)path);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Schema file is not readable: {}", (Object)path);
        }
    }
}

