/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger2markup.builder.document;

import io.github.robwin.markup.builder.MarkupDocBuilder;
import io.github.robwin.markup.builder.MarkupDocBuilders;
import io.github.robwin.markup.builder.MarkupLanguage;
import io.github.robwin.swagger2markup.config.Swagger2MarkupConfig;
import io.swagger.models.Swagger;
import java.io.IOException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MarkupDocument {
    protected static final String DELIMITER = "|";
    protected static final String DEFAULT_COLUMN = "Default";
    protected static final String REQUIRED_COLUMN = "Required";
    protected static final String SCHEMA_COLUMN = "Schema";
    protected static final String NAME_COLUMN = "Name";
    protected static final String DESCRIPTION_COLUMN = "Description";
    protected static final String DESCRIPTION = "Description";
    protected static final String PRODUCES = "Produces";
    protected static final String CONSUMES = "Consumes";
    protected static final String TAGS = "Tags";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Swagger swagger;
    protected MarkupLanguage markupLanguage;
    protected MarkupDocBuilder markupDocBuilder;

    MarkupDocument(Swagger2MarkupConfig swagger2MarkupConfig) {
        this.swagger = swagger2MarkupConfig.getSwagger();
        this.markupLanguage = swagger2MarkupConfig.getMarkupLanguage();
        this.markupDocBuilder = MarkupDocBuilders.documentBuilder((MarkupLanguage)this.markupLanguage);
    }

    public abstract MarkupDocument build() throws IOException;

    public String toString() {
        return this.markupDocBuilder.toString();
    }

    public void writeToFile(String directory, String fileName, Charset charset) throws IOException {
        this.markupDocBuilder.writeToFile(directory, fileName, charset);
    }
}

