/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger2markup.builder.document;

import com.google.common.base.Optional;
import com.google.common.collect.Multimap;
import io.github.robwin.swagger2markup.GroupBy;
import io.github.robwin.swagger2markup.builder.document.MarkupDocument;
import io.github.robwin.swagger2markup.config.Swagger2MarkupConfig;
import io.github.robwin.swagger2markup.utils.ParameterUtils;
import io.github.robwin.swagger2markup.utils.PropertyUtils;
import io.github.robwin.swagger2markup.utils.TagUtils;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Tag;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PathsDocument
extends MarkupDocument {
    private static final String PATHS = "Paths";
    private static final String RESOURCES = "Resources";
    private static final String PARAMETERS = "Parameters";
    private static final String RESPONSES = "Responses";
    private static final String EXAMPLE_CURL = "Example CURL request";
    private static final String EXAMPLE_REQUEST = "Example HTTP request";
    private static final String EXAMPLE_RESPONSE = "Example HTTP response";
    private static final String TYPE_COLUMN = "Type";
    private static final String HTTP_CODE_COLUMN = "HTTP Code";
    private static final String REQUEST_EXAMPLE_FILE_NAME = "http-request";
    private static final String RESPONSE_EXAMPLE_FILE_NAME = "http-response";
    private static final String CURL_EXAMPLE_FILE_NAME = "curl-request";
    private static final String DESCRIPTION_FILE_NAME = "description";
    private static final String PARAMETER = "Parameter";
    private boolean examplesEnabled;
    private String examplesFolderPath;
    private boolean handWrittenDescriptionsEnabled;
    private String descriptionsFolderPath;
    private final GroupBy pathsGroupedBy;

    public PathsDocument(Swagger2MarkupConfig swagger2MarkupConfig) {
        super(swagger2MarkupConfig);
        this.pathsGroupedBy = swagger2MarkupConfig.getPathsGroupedBy();
        if (StringUtils.isNotBlank((CharSequence)swagger2MarkupConfig.getExamplesFolderPath())) {
            this.examplesEnabled = true;
            this.examplesFolderPath = swagger2MarkupConfig.getExamplesFolderPath();
        }
        if (StringUtils.isNotBlank((CharSequence)swagger2MarkupConfig.getDescriptionsFolderPath())) {
            this.handWrittenDescriptionsEnabled = true;
            this.descriptionsFolderPath = swagger2MarkupConfig.getDescriptionsFolderPath() + "/" + PATHS.toLowerCase();
        }
        if (this.examplesEnabled) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Include examples is enabled.");
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Include examples is disabled.");
        }
        if (this.handWrittenDescriptionsEnabled) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Include hand-written descriptions is enabled.");
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Include hand-written descriptions is disabled.");
        }
    }

    @Override
    public MarkupDocument build() {
        this.paths();
        return this;
    }

    private void paths() {
        block6: {
            Map paths = this.swagger.getPaths();
            if (!MapUtils.isNotEmpty((Map)paths)) break block6;
            if (this.pathsGroupedBy.equals((Object)GroupBy.AS_IS)) {
                this.markupDocBuilder.sectionTitleLevel1(PATHS);
                for (Map.Entry pathEntry : paths.entrySet()) {
                    Path path = (Path)pathEntry.getValue();
                    if (path == null) continue;
                    this.createPathSections((String)pathEntry.getKey(), path);
                }
            } else {
                this.markupDocBuilder.sectionTitleLevel1(RESOURCES);
                Multimap<String, Pair<String, Path>> pathsGroupedByTag = TagUtils.groupPathsByTag(paths);
                Map<String, Tag> tagsMap = TagUtils.convertTagsListToMap(this.swagger.getTags());
                for (String tagName : pathsGroupedByTag.keySet()) {
                    this.markupDocBuilder.sectionTitleLevel2(WordUtils.capitalize((String)tagName));
                    Optional<String> tagDescription = TagUtils.getTagDescription(tagsMap, tagName);
                    if (tagDescription.isPresent()) {
                        this.markupDocBuilder.paragraph((String)tagDescription.get());
                    }
                    Collection pathsOfTag = pathsGroupedByTag.get((Object)tagName);
                    for (Pair pathPair : pathsOfTag) {
                        Path path = (Path)pathPair.getValue();
                        if (path == null) continue;
                        this.createPathSections((String)pathPair.getKey(), path);
                    }
                }
            }
        }
    }

    private void createPathSections(String pathUrl, Path path) {
        for (Map.Entry operationEntry : path.getOperationMap().entrySet()) {
            String methodAndPath = operationEntry.getKey() + " " + pathUrl;
            this.path(methodAndPath, (Operation)operationEntry.getValue());
        }
    }

    private void path(String methodAndPath, Operation operation) {
        if (operation != null) {
            this.pathTitle(methodAndPath, operation);
            this.descriptionSection(operation);
            this.parametersSection(operation);
            this.responsesSection(operation);
            this.consumesSection(operation);
            this.producesSection(operation);
            this.tagsSection(operation);
            this.examplesSection(operation);
        }
    }

    private void pathTitle(String methodAndPath, Operation operation) {
        String summary = operation.getSummary();
        if (StringUtils.isNotBlank((CharSequence)summary)) {
            String title = summary;
            this.addPathTitle(title);
            this.markupDocBuilder.listing(methodAndPath);
        } else {
            this.addPathTitle(methodAndPath);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Path processed: {}", (Object)methodAndPath);
        }
    }

    private void addPathTitle(String title) {
        if (this.pathsGroupedBy.equals((Object)GroupBy.AS_IS)) {
            this.markupDocBuilder.sectionTitleLevel2(title);
        } else {
            this.markupDocBuilder.sectionTitleLevel3(title);
        }
    }

    private void descriptionSection(Operation operation) {
        if (this.handWrittenDescriptionsEnabled) {
            String summary = operation.getSummary();
            if (StringUtils.isNotBlank((CharSequence)summary)) {
                String operationFolder = summary.replace(".", "").replace(" ", "_").toLowerCase();
                Optional<String> description = this.handWrittenPathDescription(operationFolder, DESCRIPTION_FILE_NAME);
                if (description.isPresent()) {
                    this.pathDescription((String)description.get());
                } else {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Hand-written description cannot be read. Trying to use description from Swagger source.");
                    }
                    this.pathDescription(operation.getDescription());
                }
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Hand-written description cannot be read, because summary of operation is empty. Trying to use description from Swagger source.");
                }
                this.pathDescription(operation.getDescription());
            }
        } else {
            this.pathDescription(operation.getDescription());
        }
    }

    private void pathDescription(String description) {
        if (StringUtils.isNotBlank((CharSequence)description)) {
            if (this.pathsGroupedBy.equals((Object)GroupBy.AS_IS)) {
                this.markupDocBuilder.sectionTitleLevel3("Description");
            } else {
                this.markupDocBuilder.sectionTitleLevel4("Description");
            }
            this.markupDocBuilder.paragraph(description);
        }
    }

    private void parametersSection(Operation operation) {
        List parameters = operation.getParameters();
        if (CollectionUtils.isNotEmpty((Collection)parameters)) {
            ArrayList<String> headerAndContent = new ArrayList<String>();
            List<String> header = Arrays.asList(TYPE_COLUMN, "Name", "Description", "Required", "Schema", "Default");
            headerAndContent.add(StringUtils.join(header, (String)"|"));
            for (Parameter parameter : parameters) {
                String type = ParameterUtils.getType(parameter, this.markupLanguage);
                String parameterType = WordUtils.capitalize((String)(parameter.getIn() + PARAMETER));
                List<String> content = Arrays.asList(parameterType, parameter.getName(), this.parameterDescription(operation, parameter), Boolean.toString(parameter.getRequired()), type, ParameterUtils.getDefaultValue(parameter));
                headerAndContent.add(StringUtils.join(content, (String)"|"));
            }
            if (this.pathsGroupedBy.equals((Object)GroupBy.AS_IS)) {
                this.markupDocBuilder.sectionTitleLevel3(PARAMETERS);
            } else {
                this.markupDocBuilder.sectionTitleLevel4(PARAMETERS);
            }
            this.markupDocBuilder.tableWithHeaderRow(headerAndContent);
        }
    }

    private String parameterDescription(Operation operation, Parameter parameter) {
        if (this.handWrittenDescriptionsEnabled) {
            String summary = operation.getSummary();
            String operationFolder = summary.replace(".", "").replace(" ", "_").toLowerCase();
            String parameterName = parameter.getName();
            if (StringUtils.isNotBlank((CharSequence)operationFolder) && StringUtils.isNotBlank((CharSequence)parameterName)) {
                Optional<String> description = this.handWrittenPathDescription(operationFolder + "/" + parameterName, DESCRIPTION_FILE_NAME);
                if (description.isPresent()) {
                    return (String)description.get();
                }
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Hand-written description file cannot be read. Trying to use description from Swagger source.");
                }
                return StringUtils.defaultString((String)parameter.getDescription());
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Hand-written description file cannot be read, because summary of operation or name of parameter is empty. Trying to use description from Swagger source.");
            }
            return StringUtils.defaultString((String)parameter.getDescription());
        }
        return StringUtils.defaultString((String)parameter.getDescription());
    }

    private void consumesSection(Operation operation) {
        List consumes = operation.getConsumes();
        if (CollectionUtils.isNotEmpty((Collection)consumes)) {
            if (this.pathsGroupedBy.equals((Object)GroupBy.AS_IS)) {
                this.markupDocBuilder.sectionTitleLevel3("Consumes");
            } else {
                this.markupDocBuilder.sectionTitleLevel4("Consumes");
            }
            this.markupDocBuilder.unorderedList(consumes);
        }
    }

    private void producesSection(Operation operation) {
        List produces = operation.getProduces();
        if (CollectionUtils.isNotEmpty((Collection)produces)) {
            if (this.pathsGroupedBy.equals((Object)GroupBy.AS_IS)) {
                this.markupDocBuilder.sectionTitleLevel3("Produces");
            } else {
                this.markupDocBuilder.sectionTitleLevel4("Produces");
            }
            this.markupDocBuilder.unorderedList(produces);
        }
    }

    private void tagsSection(Operation operation) {
        List tags;
        if (this.pathsGroupedBy.equals((Object)GroupBy.AS_IS) && CollectionUtils.isNotEmpty((Collection)(tags = operation.getTags()))) {
            this.markupDocBuilder.sectionTitleLevel3("Tags");
            this.markupDocBuilder.unorderedList(tags);
        }
    }

    private void examplesSection(Operation operation) {
        if (this.examplesEnabled) {
            String summary = operation.getSummary();
            if (StringUtils.isNotBlank((CharSequence)summary)) {
                Optional<String> responseExample;
                Optional<String> requestExample;
                String exampleFolder = summary.replace(".", "").replace(" ", "_").toLowerCase();
                Optional<String> curlExample = this.example(exampleFolder, CURL_EXAMPLE_FILE_NAME);
                if (curlExample.isPresent()) {
                    if (this.pathsGroupedBy.equals((Object)GroupBy.AS_IS)) {
                        this.markupDocBuilder.sectionTitleLevel3(EXAMPLE_CURL);
                    } else {
                        this.markupDocBuilder.sectionTitleLevel4(EXAMPLE_CURL);
                    }
                    this.markupDocBuilder.paragraph((String)curlExample.get());
                }
                if ((requestExample = this.example(exampleFolder, REQUEST_EXAMPLE_FILE_NAME)).isPresent()) {
                    if (this.pathsGroupedBy.equals((Object)GroupBy.AS_IS)) {
                        this.markupDocBuilder.sectionTitleLevel3(EXAMPLE_REQUEST);
                    } else {
                        this.markupDocBuilder.sectionTitleLevel4(EXAMPLE_REQUEST);
                    }
                    this.markupDocBuilder.paragraph((String)requestExample.get());
                }
                if ((responseExample = this.example(exampleFolder, RESPONSE_EXAMPLE_FILE_NAME)).isPresent()) {
                    if (this.pathsGroupedBy.equals((Object)GroupBy.AS_IS)) {
                        this.markupDocBuilder.sectionTitleLevel3(EXAMPLE_RESPONSE);
                    } else {
                        this.markupDocBuilder.sectionTitleLevel4(EXAMPLE_RESPONSE);
                    }
                    this.markupDocBuilder.paragraph((String)responseExample.get());
                }
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("Example file cannot be read, because summary of operation is empty.");
            }
        }
    }

    private Optional<String> example(String exampleFolder, String exampleFileName) {
        for (String fileNameExtension : this.markupLanguage.getFileNameExtensions()) {
            java.nio.file.Path path = Paths.get(this.examplesFolderPath, exampleFolder, exampleFileName + fileNameExtension);
            if (Files.isReadable(path)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Example file processed: {}", (Object)path);
                }
                try {
                    return Optional.fromNullable((Object)FileUtils.readFileToString((File)path.toFile(), (Charset)StandardCharsets.UTF_8).trim());
                }
                catch (IOException e) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn(String.format("Failed to read example file: %s", path), (Throwable)e);
                    continue;
                }
            }
            if (!this.logger.isWarnEnabled()) continue;
            this.logger.warn("Example file is not readable: {}", (Object)path);
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("No example file found with correct file name extension in folder: {}", (Object)Paths.get(this.examplesFolderPath, exampleFolder));
        }
        return Optional.absent();
    }

    private Optional<String> handWrittenPathDescription(String descriptionFolder, String descriptionFileName) {
        for (String fileNameExtension : this.markupLanguage.getFileNameExtensions()) {
            java.nio.file.Path path = Paths.get(this.descriptionsFolderPath, descriptionFolder, descriptionFileName + fileNameExtension);
            if (Files.isReadable(path)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Description file processed: {}", (Object)path);
                }
                try {
                    return Optional.fromNullable((Object)FileUtils.readFileToString((File)path.toFile(), (Charset)StandardCharsets.UTF_8).trim());
                }
                catch (IOException e) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn(String.format("Failed to read description file: %s", path), (Throwable)e);
                    continue;
                }
            }
            if (!this.logger.isWarnEnabled()) continue;
            this.logger.warn("Description file is not readable: {}", (Object)path);
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("No description file found with correct file name extension in folder: {}", (Object)Paths.get(this.descriptionsFolderPath, descriptionFolder));
        }
        return Optional.absent();
    }

    private void responsesSection(Operation operation) {
        Map responses = operation.getResponses();
        if (MapUtils.isNotEmpty((Map)responses)) {
            ArrayList<String> csvContent = new ArrayList<String>();
            csvContent.add("HTTP Code|Description|Schema");
            for (Map.Entry entry : responses.entrySet()) {
                Response response = (Response)entry.getValue();
                if (response.getSchema() != null) {
                    Property property = response.getSchema();
                    String type = PropertyUtils.getType(property, this.markupLanguage);
                    csvContent.add((String)entry.getKey() + "|" + response.getDescription() + "|" + type);
                    continue;
                }
                csvContent.add((String)entry.getKey() + "|" + response.getDescription() + "|" + "No Content");
            }
            if (this.pathsGroupedBy.equals((Object)GroupBy.AS_IS)) {
                this.markupDocBuilder.sectionTitleLevel3(RESPONSES);
            } else {
                this.markupDocBuilder.sectionTitleLevel4(RESPONSES);
            }
            this.markupDocBuilder.tableWithHeaderRow(csvContent);
        }
    }
}

