/*
 * Decompiled with CFR 0.152.
 */
package io.github.rongaru.mysql;

import com.smattme.MysqlExportService;
import io.github.rongaru.mysql.Database;
import java.io.File;
import java.util.Properties;

public abstract class DatabaseBackup_1
extends Database {
    public static File createBackupFile(Properties properties) {
        properties.setProperty("PRESERVE_GENERATED_ZIP", "true");
        MysqlExportService mysqlExportService = DatabaseBackup_1.exportDatabase(properties);
        return mysqlExportService.getGeneratedZipFile();
    }

    public static String createBackupQuery(Properties properties) {
        MysqlExportService mysqlExportService = DatabaseBackup_1.exportDatabase(properties);
        return mysqlExportService.getGeneratedSql();
    }

    public static MysqlExportService exportDatabase(Properties properties) {
        try {
            MysqlExportService mysqlExportService = new MysqlExportService(properties);
            mysqlExportService.export();
            return mysqlExportService;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Properties createPropertiesForBackupFile(String database, String username, String password, String host, String port, String directory) {
        Properties properties = new Properties();
        properties.setProperty("DB_HOST", host);
        properties.setProperty("DB_PORT", port);
        properties.setProperty("DB_NAME", database);
        properties.setProperty("TEMP_DIR", directory);
        properties.setProperty("DB_USERNAME", username);
        properties.setProperty("DB_PASSWORD", password);
        return properties;
    }
}

