/*
 * Decompiled with CFR 0.152.
 */
package io.github.rongaru.mysql;

import com.smattme.TablesResponse;
import com.smattme.exceptions.MysqlBackup4JException;
import io.github.rongaru.mysql.MysqlBaseServiceV2;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlImportServiceV2 {
    private String database;
    private String username;
    private String host = "localhost";
    private String port = "3306";
    private String password;
    private String sqlString;
    private String jdbcConnString;
    private String jdbcDriver;
    private boolean deleteExisting = false;
    private boolean dropExisting = false;
    private final Logger logger = LoggerFactory.getLogger(MysqlImportServiceV2.class);

    private MysqlImportServiceV2() {
    }

    public boolean importDatabase() throws SQLException, ClassNotFoundException {
        Connection connection;
        if (!this.assertValidParams()) {
            String message = "Required Parameters not set or empty \nEnsure database, username, password, sqlString params are configured \nusing their respective setters";
            this.logger.error(message);
            throw new MysqlBackup4JException(message);
        }
        if (this.jdbcConnString != null && !this.jdbcConnString.isEmpty()) {
            if (this.database == null || this.database.isEmpty()) {
                this.database = MysqlBaseServiceV2.extractDatabaseNameFromJDBCUrl(this.jdbcConnString);
                this.logger.debug("database name extracted from connection string: " + this.database);
            }
            connection = MysqlBaseServiceV2.connectWithURL(this.username, this.password, this.jdbcConnString, this.jdbcDriver);
        } else {
            connection = MysqlBaseServiceV2.connect(this.username, this.password, this.host, this.port, this.database, this.jdbcDriver);
        }
        Statement stmt = connection.createStatement();
        stmt.addBatch("SET FOREIGN_KEY_CHECKS = 0");
        if (this.deleteExisting || this.dropExisting) {
            TablesResponse allTablesAndViews = MysqlBaseServiceV2.getAllTablesAndViews(this.database, stmt);
            List tables = allTablesAndViews.getTables();
            this.logger.debug("tables found for deleting/dropping: \n" + tables.toString());
            for (String table : tables) {
                String view;
                if (this.deleteExisting && !this.dropExisting) {
                    view = "DELETE FROM `" + table + "`;";
                    this.logger.debug("adding " + view + " to batch");
                    stmt.addBatch(view);
                }
                if (!this.dropExisting) continue;
                view = "DROP TABLE IF EXISTS `" + table + "`";
                this.logger.debug("adding " + view + " to batch");
                stmt.addBatch(view);
            }
            List views = allTablesAndViews.getViews();
            for (String view : views) {
                if (!this.dropExisting) continue;
                String dropQ = "DROP VIEW IF EXISTS `" + view + "`";
                this.logger.debug("adding " + dropQ + " to batch");
                stmt.addBatch(dropQ);
            }
        }
        while (this.sqlString.contains("-- start")) {
            String table;
            int startIndex = this.sqlString.indexOf("-- start");
            int endIndex = this.sqlString.indexOf("-- end");
            table = this.sqlString.substring(startIndex, endIndex).trim();
            this.logger.debug("adding extracted executable SQL chunk to batch : \n" + table);
            stmt.addBatch(table);
            this.sqlString = this.sqlString.substring(endIndex + 1);
        }
        stmt.addBatch("SET FOREIGN_KEY_CHECKS = 1");
        long[] result = stmt.executeLargeBatch();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(result.length + " queries were executed in batches for provided SQL String with the following result : \n" + Arrays.toString(result));
        }
        stmt.close();
        connection.close();
        return true;
    }

    private boolean assertValidParams() {
        return this.username != null && !this.username.isEmpty() && this.sqlString != null && !this.sqlString.isEmpty() && (this.database != null && !this.database.isEmpty() || this.jdbcConnString != null && !this.jdbcConnString.isEmpty());
    }

    public static MysqlImportServiceV2 builder() {
        return new MysqlImportServiceV2();
    }

    public MysqlImportServiceV2 setDatabase(String database) {
        this.database = database;
        return this;
    }

    public MysqlImportServiceV2 setUsername(String username) {
        this.username = username;
        return this;
    }

    public MysqlImportServiceV2 setPassword(String password) {
        this.password = password;
        return this;
    }

    public MysqlImportServiceV2 setSqlString(String sqlString) {
        this.sqlString = sqlString;
        return this;
    }

    public MysqlImportServiceV2 setDeleteExisting(boolean deleteExisting) {
        this.deleteExisting = deleteExisting;
        return this;
    }

    public MysqlImportServiceV2 setDropExisting(boolean dropExistingTable) {
        this.dropExisting = dropExistingTable;
        return this;
    }

    public MysqlImportServiceV2 setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
        return this;
    }

    public MysqlImportServiceV2 setJdbcConnString(String jdbcConnString) {
        this.jdbcConnString = jdbcConnString;
        return this;
    }

    public MysqlImportServiceV2 setHost(String host) {
        this.host = host;
        return this;
    }

    public MysqlImportServiceV2 setPort(String port) {
        this.port = port;
        return this;
    }
}

