/*
 * Decompiled with CFR 0.152.
 */
package com.lehman.knit;

import com.lehman.knit.AnnotationRow;
import com.lehman.knit.AnnotationTable;
import com.lehman.knit.DwArgument;
import com.lehman.knit.DwCommentAnnotation;
import com.lehman.knit.DwDocWriter;
import com.lehman.knit.DwFile;
import com.lehman.knit.DwFunction;
import com.lehman.knit.DwVariable;
import com.lehman.knit.KnitKeyWord;
import com.lehman.knit.Util;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class HTMLDwDocWriterImpl
implements DwDocWriter {
    private String br = "<br/>";
    private boolean writeHeaderTable = false;
    private String outputHeaderText = "";
    private String outputFooterText = "";
    private String cssFileName = "knit-style.css";

    public String getCssFileName() {
        return this.cssFileName;
    }

    public void setCssFileName(String cssFileName) {
        this.cssFileName = cssFileName;
    }

    @Override
    public void setOptions(boolean WriteHeaderTable, String OutputHeaderText, String OutputFooterText) {
        this.writeHeaderTable = WriteHeaderTable;
        this.outputHeaderText = OutputHeaderText;
        this.outputFooterText = OutputFooterText;
    }

    @Override
    public byte[] writeDoc(List<DwFile> files) {
        return this.writeDoc(files, new ArrayList<String>());
    }

    @Override
    public byte[] writeDoc(List<DwFile> files, List<String> moduleNameList) {
        String ret = "<html>" + System.lineSeparator();
        ret = ret + "<head>" + System.lineSeparator();
        ret = ret + "<title>Knit DW Documentation</title>" + System.lineSeparator();
        ret = ret + "<link rel=\"stylesheet\" href=\"" + this.cssFileName + "\">" + System.lineSeparator();
        ret = ret + "</head>" + System.lineSeparator();
        ret = ret + "<body>" + System.lineSeparator();
        if (!this.outputHeaderText.equals("")) {
            ret = ret + "<div class=\"output-header-section\">" + this.outputHeaderText + "</div>" + this.br + System.lineSeparator();
        }
        if (this.writeHeaderTable) {
            ret = ret + "<div class=\"output-header-table-section\">" + this.writeHeaderTable(files, moduleNameList) + "</div>" + this.br;
        }
        for (String modName : moduleNameList) {
            DwFile modFile = this.getFileByModuleName(files, modName);
            if (modFile != null) {
                ret = ret + this.writeDoc(modFile) + this.br + System.lineSeparator();
                continue;
            }
            System.err.println("Warning: Module name '" + modName + "' was supplied in moduleNameList but was not found parsed file list.");
        }
        for (DwFile dwf : files) {
            if (moduleNameList.contains(dwf.getName())) continue;
            ret = ret + this.writeDoc(dwf) + this.br + System.lineSeparator();
        }
        if (!this.outputFooterText.equals("")) {
            ret = ret + "<div class=\"output-footer-section\">" + this.outputFooterText + "</div>" + this.br + System.lineSeparator();
        }
        ret = ret + "</body>" + System.lineSeparator();
        ret = ret + "</html>" + System.lineSeparator();
        return ret.getBytes(StandardCharsets.UTF_8);
    }

    private String writeDoc(DwFile file) {
        String functs;
        String ret = "<h1 id=\"" + file.name + "\">" + file.name + "</h1>" + System.lineSeparator();
        ret = ret + "<h3>" + Util.join("::", file.modulePath) + "</h3>" + System.lineSeparator();
        if (!file.getComment().getText().equals("")) {
            ret = ret + file.getComment().getText() + this.br + System.lineSeparator();
            if (file.getTable() != null) {
                ret = ret + this.writeAnnotationTable(file.getTable()) + this.br + System.lineSeparator();
            }
        }
        ret = ret + this.br + System.lineSeparator();
        String vars = this.writeVariables(file);
        if (!vars.equals("")) {
            ret = ret + "<h3>Variables</h3>" + System.lineSeparator();
            ret = ret + vars + this.br + System.lineSeparator();
        }
        if (!(functs = this.writeFunctions(file)).equals("")) {
            ret = ret + "<h3>Functions</h3>" + System.lineSeparator();
            ret = ret + functs + this.br + System.lineSeparator();
        }
        return ret;
    }

    private String writeHeaderTable(List<DwFile> files) {
        return this.writeHeaderTable(files, new ArrayList<String>());
    }

    private String writeHeaderTable(List<DwFile> files, List<String> moduleNameList) {
        String ret = "<table class=\"table-header\">";
        ret = ret + "<tr class=\"table-header-header-row\"><th class=\"table-header-header-cell\">Module</th><th class=\"table-header-header-cell\">Description</th></tr>" + System.lineSeparator();
        for (String modName : moduleNameList) {
            DwFile modFile = this.getFileByModuleName(files, modName);
            if (modFile != null) {
                ret = ret + "<tr class=\"table-header-row\"><td class=\"table-header-cell\"><a href=\"#" + modFile.getName() + "\">" + modFile.getName() + "</a></td><td class=\"table-header-cell\">" + Util.stripNewLines(modFile.getComment().getText()) + "</td></tr>" + System.lineSeparator();
                continue;
            }
            System.err.println("Warning: Module name '" + modName + "' was supplied in moduleNameList but was not found parsed file list.");
        }
        for (DwFile dwf : files) {
            if (moduleNameList.contains(dwf.getName())) continue;
            ret = ret + "<tr class=\"table-header-row\"><td class=\"table-header-cell\"><a href=\"#" + dwf.getName() + "\">" + dwf.getName() + "</a></td><td class=\"table-header-cell\">" + Util.stripNewLines(dwf.getComment().getText()) + "</td></tr>" + System.lineSeparator();
        }
        ret = ret + "</table>" + System.lineSeparator();
        return ret;
    }

    private DwFile getFileByModuleName(List<DwFile> files, String name) {
        DwFile ret = null;
        for (DwFile dwf : files) {
            if (!dwf.getName().equals(name)) continue;
            ret = dwf;
            break;
        }
        return ret;
    }

    private String writeVariables(DwFile file) {
        String ret = "";
        if (file.getVariables().size() > 0) {
            ret = ret + "<div class=\"variable-section\">";
            for (DwVariable var : file.getVariables()) {
                ret = ret + "<div class=\"variable-title-line\"><span class=\"variable-var\">var</span> <span class=\"variable-name\">" + var.getName() + "</span></div>" + this.br + System.lineSeparator();
                ret = ret + "<div class=\"variable-body-section\">" + this.br + System.lineSeparator();
                ret = ret + "<div class=\"variable-comment-text\">" + var.getComment().getText().replaceAll(System.lineSeparator(), this.br + System.lineSeparator()) + "</div>" + this.br + System.lineSeparator();
                if (var.getTable() != null) {
                    ret = ret + this.writeAnnotationTable(var.getTable()) + this.br + System.lineSeparator();
                }
                ret = ret + "</div>" + this.br + System.lineSeparator();
            }
            ret = ret + "</div>" + System.lineSeparator();
        }
        return ret;
    }

    private String writeFunctions(DwFile file) {
        String ret = "";
        if (file.getFunctions().size() > 0) {
            ret = ret + "<div class=\"function-section\">";
            for (DwFunction fun : file.getFunctions()) {
                ret = ret + "<div class=\"function-title-line\"><span class=\"function-fun\">fun</span>  <span class=\"function-name\">" + fun.getName() + "</span> (<span class=\"function-args\">" + this.writeFunctArgs(fun) + "</span>)</div>" + this.br + System.lineSeparator();
                ret = ret + "<div class=\"function-body-section\">" + this.br + System.lineSeparator();
                ret = ret + this.writeFunctAnnotations(fun) + this.br + System.lineSeparator();
                ret = ret + "<div class=\"function-comment-text\">" + Util.stripNewLines(fun.getComment().getText()) + "</div>" + this.br + System.lineSeparator();
                if (fun.getTable() != null) {
                    ret = ret + this.writeAnnotationTable(fun.getTable()) + this.br + System.lineSeparator();
                }
                ret = ret + "</div>" + this.br + System.lineSeparator();
            }
            ret = ret + "</div>" + System.lineSeparator();
        }
        return ret;
    }

    private String writeFunctArgs(DwFunction fun) {
        String ret = "";
        for (int i = 0; i < fun.getArguments().size(); ++i) {
            DwArgument arg;
            if (i > 0) {
                ret = ret + ", ";
            }
            if ((arg = fun.getArguments().get(i)).getDatatype().equals("")) {
                if (arg.getName().equals("")) continue;
                ret = ret + "<span class=\"function-arg-name\">" + arg.getName() + "</span>";
                continue;
            }
            ret = ret + "<span class=\"function-arg-name\">" + arg.getName() + "</span>:<span class=\"function-arg-datatype\">" + arg.getDatatype() + "</span>";
        }
        return ret;
    }

    private String writeFunctAnnotations(DwFunction fun) {
        String ret = "";
        DwCommentAnnotation retAnn = null;
        for (DwCommentAnnotation ann : fun.getComment().getAnnotations()) {
            if (ann.getName().toLowerCase().equals(KnitKeyWord.R.getVal()) || ann.getName().toLowerCase().equals(KnitKeyWord.RETURN.getVal())) {
                retAnn = ann;
                continue;
            }
            if (!ann.getName().toLowerCase().equals(KnitKeyWord.P.getVal()) && !ann.getName().toLowerCase().equals(KnitKeyWord.PARAM.getVal())) continue;
            ret = ret + "<span class=\"function-ann-param\">param</span> <span class=\"function-ann-key\">" + ann.getKey() + "</span> <span class=\"function-ann-value\">" + Util.stripNewLines(ann.getValue()) + "</span>" + this.br + System.lineSeparator();
        }
        if (retAnn != null) {
            ret = ret + "<span class=\"function-ann-return\">return</span> <span class=\"function-ann-return-value\">" + Util.stripNewLines(retAnn.getValue()) + "</span>" + this.br + System.lineSeparator();
        }
        String retstr = "";
        if (!ret.equals("")) {
            retstr = "<div class=\"function-ann-section\">" + ret + "</div>";
        }
        return retstr;
    }

    private String writeAnnotationTable(AnnotationTable tbl) {
        String ret = "<table class=\"table-ann\">";
        ret = ret + "<tr class=\"table-ann-header-row\"><th class=\"table-ann-header-cell\">" + Util.join("</th><th class=\"table-ann-header-cell\">", tbl.getColumns()) + "</th></tr>" + System.lineSeparator();
        for (AnnotationRow row : tbl.getRows()) {
            ret = ret + "<tr class=\"table-ann-row\"><td class=\"table-ann-cell\">" + Util.join("</td><td class=\"table-ann-cell\">", row.getFields()) + "</td></tr>" + System.lineSeparator();
        }
        ret = ret + "</table>";
        return ret;
    }
}

