/*
 * Decompiled with CFR 0.152.
 */
package com.lehman.knit;

import com.lehman.knit.AnnotationRow;
import com.lehman.knit.AnnotationTable;
import com.lehman.knit.DwArgument;
import com.lehman.knit.DwComment;
import com.lehman.knit.DwCommentAnnotation;
import com.lehman.knit.DwFile;
import com.lehman.knit.DwFunction;
import com.lehman.knit.DwVariable;
import com.lehman.knit.KnitKeyWord;
import com.lehman.knit.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KnitParser {
    public DwFile parseFile(String rootDirName, String fileName, String dwlFileExt) throws IOException {
        DwFile ret = new DwFile(fileName.replaceFirst(rootDirName, ""), dwlFileExt);
        String fileStr = Util.read(fileName);
        this.parseModuleComment(fileStr, ret);
        ret.setVariables(this.parseVariables(fileStr));
        ret.setFunctions(this.parseFunctions(fileStr));
        return ret;
    }

    private void parseModuleComment(String text, DwFile ret) {
        String funPatternStr = "(\\/\\*\\*((.(?!\\/\\*\\*))+?)\\*\\/\\s*%dw)";
        Pattern r = Pattern.compile(funPatternStr, 40);
        Matcher m = r.matcher(text);
        if (m.find()) {
            String commentStr = m.group(2).toString();
            ret.setCommentString(this.parseCommentString(commentStr).trim());
            ret.setComment(this.parseComment(ret.getCommentString()));
            ret.setTable(this.parseAnnotationTable(ret.getComment()));
        }
    }

    private ArrayList<DwFunction> parseFunctions(String text) {
        ArrayList<DwFunction> ret = new ArrayList<DwFunction>();
        String funPatternStr = "(\\/\\*\\*(.(?!\\/\\*\\*))+?\\*\\/\\s*fun\\s*\\w*\\s*\\(.*?\\))";
        Pattern r = Pattern.compile(funPatternStr, 40);
        Matcher m = r.matcher(text);
        while (m.find()) {
            for (int i = 1; i < m.groupCount(); ++i) {
                ret.add(this.parseFunctionString(m.group(i).toString()));
            }
        }
        return ret;
    }

    private DwFunction parseFunctionString(String functionString) {
        DwFunction funct = new DwFunction();
        String funPatternStr = "\\/\\*\\*(.+?)\\*\\/\\s*fun\\s*(\\w*)\\s*\\((.*?)\\)";
        Pattern r = Pattern.compile(funPatternStr, 40);
        Matcher m = r.matcher(functionString);
        while (m.find()) {
            funct.setCommentString(this.parseCommentString(m.group(1).toString()).trim());
            funct.setName(m.group(2).toString());
            funct.setComment(this.parseComment(funct.getCommentString()));
            funct.setTable(this.parseAnnotationTable(funct.getComment()));
            funct.setArguments(this.parseArguments(m.group(3).toString()));
        }
        return funct;
    }

    private String parseCommentString(String str) {
        String ret = "";
        for (String line : str.toString().split(System.lineSeparator())) {
            ret = ret + line.replaceFirst("^\\s\\*\\s?", "") + System.lineSeparator();
        }
        return ret;
    }

    private DwComment parseComment(String str) {
        DwComment comment = new DwComment();
        String pstr = "(.*?)(^@.*)";
        Pattern r = Pattern.compile(pstr, 40);
        Matcher m = r.matcher(str);
        if (m.find()) {
            comment.setText(m.group(1).toString());
            String annStr = m.group(2).toString();
            comment.setAnnotations(this.parseAnnotations(annStr));
        } else {
            comment.setText(str);
        }
        return comment;
    }

    private ArrayList<DwCommentAnnotation> parseAnnotations(String str) {
        ArrayList<DwCommentAnnotation> ret = new ArrayList<DwCommentAnnotation>();
        String pstr = "^@(\\w+)\\s(.*?(?=@))";
        Pattern r = Pattern.compile(pstr, 40);
        Matcher m = r.matcher(str + System.lineSeparator() + "@");
        while (m.find()) {
            DwCommentAnnotation ann = new DwCommentAnnotation();
            ann.setName(m.group(1).toString());
            String kvStr = m.group(2).toString();
            if (ann.getName().equals(KnitKeyWord.P.getVal()) || ann.getName().equals(KnitKeyWord.PARAM.getVal())) {
                this.parseAnnotationValue(kvStr, ann);
            } else {
                ann.setValue(kvStr);
            }
            ret.add(ann);
        }
        return ret;
    }

    private void parseAnnotationValue(String str, DwCommentAnnotation ann) {
        String pstr = "(\\w+)\\s(.*)";
        Pattern r = Pattern.compile(pstr, 40);
        Matcher m = r.matcher(str);
        if (m.find()) {
            ann.setKey(m.group(1).toString());
            ann.setValue(m.group(2).toString());
        }
    }

    private ArrayList<DwArgument> parseArguments(String str) {
        String[] parts;
        ArrayList<DwArgument> args = new ArrayList<DwArgument>();
        for (String part : parts = str.split(",")) {
            DwArgument arg = new DwArgument();
            if (part.contains(":")) {
                String[] argParts = part.split(":");
                arg.setName(argParts[0].trim());
                arg.setDatatype(argParts[1].trim());
            } else {
                arg.setName(part.trim());
            }
            args.add(arg);
        }
        return args;
    }

    private ArrayList<DwVariable> parseVariables(String text) {
        ArrayList<DwVariable> variables = new ArrayList<DwVariable>();
        String funPatternStr = "(\\/\\*\\*(.(?!\\/\\*\\*))+?\\*\\/\\s*var\\s*\\w*)";
        Pattern r = Pattern.compile(funPatternStr, 40);
        Matcher m = r.matcher(text);
        while (m.find()) {
            for (int i = 1; i < m.groupCount(); ++i) {
                variables.add(this.parseVariableString(m.group(i).toString()));
            }
        }
        return variables;
    }

    private DwVariable parseVariableString(String variableString) {
        DwVariable var = new DwVariable();
        String varPatternStr = "\\/\\*\\*(.+?)\\*\\/\\s*var\\s*(\\w*)";
        Pattern r = Pattern.compile(varPatternStr, 40);
        Matcher m = r.matcher(variableString);
        while (m.find()) {
            var.setCommentString(this.parseCommentString(m.group(1).toString()).trim());
            var.setName(m.group(2).toString());
            var.setComment(this.parseComment(var.getCommentString()));
            var.setTable(this.parseAnnotationTable(var.getComment()));
        }
        return var;
    }

    private AnnotationTable parseAnnotationTable(DwComment comment) {
        AnnotationTable tbl = null;
        for (DwCommentAnnotation ann : comment.getAnnotations()) {
            if (!ann.getName().toLowerCase().equals(KnitKeyWord.TBL.getVal()) && !ann.getName().toLowerCase().equals(KnitKeyWord.TABLE.getVal())) continue;
            tbl = new AnnotationTable();
            ArrayList<String> cols = new ArrayList<String>();
            for (String col : Util.fromArray(ann.getValue().split("(?<!\\\\\\\\),"))) {
                cols.add(col.replaceAll(System.lineSeparator(), ""));
            }
            tbl.setColumns(cols);
            break;
        }
        if (tbl != null) {
            ArrayList<AnnotationRow> rows = new ArrayList<AnnotationRow>();
            for (DwCommentAnnotation ann : comment.getAnnotations()) {
                if (!ann.getName().toLowerCase().equals(KnitKeyWord.ROW.getVal())) continue;
                AnnotationRow row = new AnnotationRow();
                ArrayList<String> fields = new ArrayList<String>();
                for (String str : ann.getValue().split("(?<!\\\\\\\\),")) {
                    fields.add(str.replaceAll("\\\\\\\\,", ",").replaceAll(System.lineSeparator(), ""));
                }
                row.setFields(fields);
                rows.add(row);
            }
            tbl.setRows(rows);
        }
        return tbl;
    }
}

