/*
 * Decompiled with CFR 0.152.
 */
package com.lehman.knit;

import com.lehman.knit.DwDocWriter;
import com.lehman.knit.DwFile;
import com.lehman.knit.HTMLDwDocWriterImpl;
import com.lehman.knit.KnitParser;
import com.lehman.knit.MarkdownDwDocWriterImpl;
import com.lehman.knit.OutputFormat;
import com.lehman.knit.PdfDwDocWriterImpl;
import com.lehman.knit.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="knit", defaultPhase=LifecyclePhase.PACKAGE)
public class Main
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(property="generate")
    boolean generate = true;
    @Parameter(property="files")
    String[] files;
    @Parameter(property="directories")
    String[] directories = new String[]{"src/main/resources/dw"};
    @Parameter(property="singleOutputFile")
    boolean singleOutputFile = true;
    @Parameter(property="outputFile")
    String outputFile = "target/knit-doc.md";
    @Parameter(property="outputFormat")
    String outputFormat = OutputFormat.MARKDOWN.getVal();
    @Parameter(property="outputHeaderText")
    String outputHeaderText = "";
    @Parameter(property="outputFooterText")
    String outputFooterText = "";
    @Parameter(property="outputHtmlCssFile")
    String outputHtmlCssFile = "";
    @Parameter(property="writeHeaderTable")
    boolean writeHeaderTable = false;
    @Parameter(property="moduleList")
    String[] moduleList = new String[0];
    @Parameter(property="dwlFileExt")
    String dwlFileExt = "dwl";

    public void setDirectories(String[] Directories) {
        if (Directories.length > 0) {
            this.directories = Directories;
        }
    }

    public void setFiles(String[] Files) {
        this.files = Files;
    }

    public void setModuleList(String[] ModuleList) {
        this.moduleList = ModuleList;
    }

    public static void main(String[] args) throws Exception {
        Main mn = new Main();
        ArrayList<DwFile> parsedFiles = new ArrayList<DwFile>();
        mn.parseDirectory("dw", parsedFiles);
        MarkdownDwDocWriterImpl writer = new MarkdownDwDocWriterImpl();
        String doc = new String(writer.writeDoc(parsedFiles));
        System.out.println(doc);
    }

    public void parseDirectory(String dirName, ArrayList<DwFile> parsedFiles) throws Exception {
        KnitParser parser = new KnitParser();
        File dir = new File(dirName);
        if (dir.exists()) {
            if (dir.isDirectory()) {
                for (String name : dir.list()) {
                    String relName = dirName + "/" + name;
                    File f = new File(relName);
                    if (f.isFile() && relName.endsWith("." + this.dwlFileExt)) {
                        parsedFiles.add(parser.parseFile(dirName, relName, this.dwlFileExt));
                        continue;
                    }
                    if (!f.isDirectory()) continue;
                    this.parseDirectory(relName, parsedFiles);
                }
            } else {
                System.err.println("Provided directory '" + dirName + "' isn't a directory.");
            }
        } else {
            System.err.println("Provided directory '" + dirName + "' doesn't exist.");
        }
    }

    public void execute() {
        this.printAbout();
        System.out.println("Running Knit doc generator ...");
        try {
            if (this.generate) {
                if (!this.singleOutputFile) {
                    System.err.println("Error: knit-maven-plugin <singleOutputFile> is set to false but only single file is currently implemented.");
                    System.exit(1);
                }
                if (this.files.length > 0 || this.directories.length > 0) {
                    if (this.outputFormat.equals(OutputFormat.MARKDOWN.getVal())) {
                        this.writeDocFile(OutputFormat.MARKDOWN);
                    } else if (this.outputFormat.equals(OutputFormat.PDF.getVal())) {
                        this.writeDocFile(OutputFormat.PDF);
                    } else if (this.outputFormat.equals(OutputFormat.HTML.getVal())) {
                        this.writeDocFile(OutputFormat.HTML);
                    } else {
                        System.err.println("Error: knit-maven-plugin output format '" + this.outputFormat + "' not valid. Options are 'markdown', 'pdf', 'html'.");
                        System.exit(1);
                    }
                } else {
                    System.err.println("Error: knit-maven-plugin <srcFiles> or <srcDirectories> aren't specified.");
                    System.exit(1);
                }
            } else {
                System.out.println("Info: knit-maven-plugin skipping doc generation. (generate=false)");
            }
        }
        catch (Exception e) {
            System.err.println("Bad news, the knit plugin ran into trouble. If it continues please report it at https://github.com/rsv-code/knit." + System.lineSeparator());
            e.printStackTrace();
        }
    }

    private void writeDocFile(OutputFormat format) {
        ArrayList<DwFile> parsedFiles = new ArrayList<DwFile>();
        try {
            for (String dir : this.directories) {
                this.parseDirectory(this.getWorkingDirectory() + "/" + dir, parsedFiles);
            }
            KnitParser parser = new KnitParser();
            for (String fname : this.files) {
                File f = new File(this.getWorkingDirectory() + "/" + fname);
                parsedFiles.add(parser.parseFile(this.getWorkingDirectory(), fname, this.dwlFileExt));
            }
            DwDocWriter writer = null;
            if (format == OutputFormat.MARKDOWN) {
                writer = new MarkdownDwDocWriterImpl();
            } else if (format == OutputFormat.PDF) {
                writer = new PdfDwDocWriterImpl();
            } else if (format == OutputFormat.HTML) {
                writer = new HTMLDwDocWriterImpl();
                if (!this.outputHtmlCssFile.trim().equals("")) {
                    ((HTMLDwDocWriterImpl)writer).setCssFileName(this.outputHtmlCssFile.trim());
                } else {
                    String parentDir = new File(this.getWorkingDirectory() + "/" + this.outputFile).getParent();
                    Util.write(parentDir + "/" + ((HTMLDwDocWriterImpl)writer).getCssFileName(), this.getDefaultCssFile().getBytes(StandardCharsets.UTF_8), false);
                }
            }
            writer.setOptions(this.writeHeaderTable, this.outputHeaderText, this.outputFooterText);
            byte[] doc = new byte[]{};
            doc = writer.writeDoc(parsedFiles, Arrays.asList(this.moduleList));
            Util.write(this.getWorkingDirectory() + "/" + this.outputFile, doc, false);
            System.out.println("Document has been written to '" + this.outputFile + "'.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Error: knit-maven-plugin parse failed.");
        }
    }

    private String getWorkingDirectory() {
        Model model = this.project.getModel();
        Build build = model.getBuild();
        File dir = new File(build.getDirectory());
        String ret = dir.getParent();
        if (SystemUtils.IS_OS_WINDOWS) {
            ret = ret.replace("\\", "/");
        }
        return ret;
    }

    private String getDefaultCssFile() {
        String ret = "";
        try {
            String line;
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/defaultCssFile.css");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                ret = ret + line + System.lineSeparator();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private void printAbout() {
        String out = "";
        out = out + " __  __     __   __     __     ______      _____     ______     ______                            " + System.lineSeparator() + "/\\ \\/ /    /\\ \"-.\\ \\   /\\ \\   /\\__  _\\    /\\  __-.  /\\  __ \\   /\\  ___\\                           " + System.lineSeparator() + "\\ \\  _\"-.  \\ \\ \\-.  \\  \\ \\ \\  \\/_/\\ \\/    \\ \\ \\/\\ \\ \\ \\ \\/\\ \\  \\ \\ \\____                          " + System.lineSeparator() + " \\ \\_\\ \\_\\  \\ \\_\\\\\"\\_\\  \\ \\_\\    \\ \\_\\     \\ \\____-  \\ \\_____\\  \\ \\_____\\                         " + System.lineSeparator() + "  \\/_/\\/_/   \\/_/ \\/_/   \\/_/     \\/_/      \\/____/   \\/_____/   \\/_____/                         " + System.lineSeparator() + "                                                                                                  " + System.lineSeparator() + " ______     ______     __   __     ______     ______     ______     ______   ______     ______    " + System.lineSeparator() + "/\\  ___\\   /\\  ___\\   /\\ \"-.\\ \\   /\\  ___\\   /\\  == \\   /\\  __ \\   /\\__  _\\ /\\  __ \\   /\\  == \\   " + System.lineSeparator() + "\\ \\ \\__ \\  \\ \\  __\\   \\ \\ \\-.  \\  \\ \\  __\\   \\ \\  __<   \\ \\  __ \\  \\/_/\\ \\/ \\ \\ \\/\\ \\  \\ \\  __<   " + System.lineSeparator() + " \\ \\_____\\  \\ \\_____\\  \\ \\_\\\\\"\\_\\  \\ \\_____\\  \\ \\_\\ \\_\\  \\ \\_\\ \\_\\    \\ \\_\\  \\ \\_____\\  \\ \\_\\ \\_\\ " + System.lineSeparator() + "  \\/_____/   \\/_____/   \\/_/ \\/_/   \\/_____/   \\/_/ /_/   \\/_/\\/_/     \\/_/   \\/_____/   \\/_/ /_/ " + System.lineSeparator() + "                                                                                                  " + System.lineSeparator();
        out = out + "Knit 1.0.13 - DataWeave Document Generator" + System.lineSeparator();
        out = out + "Written By Austin Lehman" + System.lineSeparator();
        out = out + "austin@rosevillecode.com" + System.lineSeparator();
        out = out + "Copyright 2020 Roseville Code Inc." + System.lineSeparator();
        System.out.println(out);
    }
}

