/*
 * Decompiled with CFR 0.152.
 */
package com.lehman.knit;

import com.lehman.knit.AnnotationRow;
import com.lehman.knit.AnnotationTable;
import com.lehman.knit.DwArgument;
import com.lehman.knit.DwCommentAnnotation;
import com.lehman.knit.DwDocWriter;
import com.lehman.knit.DwFile;
import com.lehman.knit.DwFunction;
import com.lehman.knit.DwVariable;
import com.lehman.knit.KnitKeyWord;
import com.lehman.knit.Util;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class MarkdownDwDocWriterImpl
implements DwDocWriter {
    private boolean writeHeaderTable = false;
    private String outputHeaderText = "";
    private String outputFooterText = "";

    @Override
    public void setOptions(boolean WriteHeaderTable, String OutputHeaderText, String OutputFooterText) {
        this.writeHeaderTable = WriteHeaderTable;
        this.outputHeaderText = OutputHeaderText;
        this.outputFooterText = OutputFooterText;
    }

    @Override
    public byte[] writeDoc(List<DwFile> files) {
        return this.writeDoc(files, new ArrayList<String>());
    }

    @Override
    public byte[] writeDoc(List<DwFile> files, List<String> moduleNameList) {
        String ret = "";
        if (!this.outputHeaderText.equals("")) {
            ret = ret + this.outputHeaderText + System.lineSeparator() + System.lineSeparator();
        }
        if (this.writeHeaderTable) {
            ret = ret + this.writeHeaderTable(files, moduleNameList);
        }
        for (String modName : moduleNameList) {
            DwFile modFile = this.getFileByModuleName(files, modName);
            if (modFile != null) {
                ret = ret + this.writeDoc(modFile) + System.lineSeparator();
                continue;
            }
            System.err.println("Warning: Module name '" + modName + "' was supplied in moduleNameList but was not found parsed file list.");
        }
        for (DwFile dwf : files) {
            if (moduleNameList.contains(dwf.getName())) continue;
            ret = ret + this.writeDoc(dwf) + System.lineSeparator();
        }
        if (!this.outputFooterText.equals("")) {
            ret = ret + this.outputFooterText + System.lineSeparator() + System.lineSeparator();
        }
        return ret.getBytes(StandardCharsets.UTF_8);
    }

    private String writeDoc(DwFile file) {
        String functs;
        String ret = "# " + file.name + System.lineSeparator();
        ret = ret + "###### " + Util.join("::", file.modulePath) + System.lineSeparator();
        if (!file.getComment().getText().equals("")) {
            ret = ret + file.getComment().getText() + System.lineSeparator();
            if (file.getTable() != null) {
                ret = ret + this.writeAnnotationTable(file.getTable()) + System.lineSeparator() + System.lineSeparator();
            }
        }
        ret = ret + System.lineSeparator();
        String vars = this.writeVariables(file);
        if (!vars.equals("")) {
            ret = ret + "### Variables" + System.lineSeparator();
            ret = ret + vars + System.lineSeparator();
        }
        if (!(functs = this.writeFunctions(file)).equals("")) {
            ret = ret + "### Functions" + System.lineSeparator();
            ret = ret + functs + System.lineSeparator();
        }
        return ret;
    }

    private String writeHeaderTable(List<DwFile> files) {
        return this.writeHeaderTable(files, new ArrayList<String>());
    }

    private String writeHeaderTable(List<DwFile> files, List<String> moduleNameList) {
        String ret = "";
        ret = ret + "| Module | Description |" + System.lineSeparator();
        ret = ret + "|-|-|" + System.lineSeparator();
        for (String modName : moduleNameList) {
            DwFile modFile = this.getFileByModuleName(files, modName);
            if (modFile != null) {
                ret = ret + "| [" + modFile.getName() + "](#" + modFile.getName() + ") | " + Util.stripNewLines(modFile.getComment().getText()) + " |" + System.lineSeparator();
                continue;
            }
            System.err.println("Warning: Module name '" + modName + "' was supplied in moduleNameList but was not found parsed file list.");
        }
        for (DwFile dwf : files) {
            if (moduleNameList.contains(dwf.getName())) continue;
            ret = ret + "| [" + dwf.getName() + "](#" + dwf.getName() + ") | " + Util.stripNewLines(dwf.getComment().getText()) + " |" + System.lineSeparator();
        }
        ret = ret + System.lineSeparator();
        return ret;
    }

    private DwFile getFileByModuleName(List<DwFile> files, String name) {
        DwFile ret = null;
        for (DwFile dwf : files) {
            if (!dwf.getName().equals(name)) continue;
            ret = dwf;
            break;
        }
        return ret;
    }

    private String writeVariables(DwFile file) {
        String ret = "";
        for (DwVariable var : file.getVariables()) {
            ret = ret + "__var__ `" + var.getName() + "`" + System.lineSeparator();
            ret = ret + "> " + var.getComment().getText().replaceAll(System.lineSeparator(), "  " + System.lineSeparator()) + System.lineSeparator() + System.lineSeparator();
            if (var.getTable() == null) continue;
            ret = ret + this.writeAnnotationTable(var.getTable()) + System.lineSeparator() + System.lineSeparator();
        }
        return ret;
    }

    private String writeFunctions(DwFile file) {
        String ret = "";
        for (DwFunction fun : file.getFunctions()) {
            ret = ret + "__fun__ `" + fun.getName() + "` ( " + this.writeFunctArgs(fun) + ")" + System.lineSeparator() + System.lineSeparator();
            ret = ret + this.writeFunctAnnotations(fun) + System.lineSeparator();
            ret = ret + "> " + Util.stripNewLines(fun.getComment().getText()) + System.lineSeparator() + System.lineSeparator();
            if (fun.getTable() == null) continue;
            ret = ret + this.writeAnnotationTable(fun.getTable()) + System.lineSeparator() + System.lineSeparator();
        }
        return ret;
    }

    private String writeFunctArgs(DwFunction fun) {
        String ret = "";
        for (int i = 0; i < fun.getArguments().size(); ++i) {
            DwArgument arg;
            if (i > 0) {
                ret = ret + ", ";
            }
            if ((arg = fun.getArguments().get(i)).getDatatype().equals("")) {
                if (arg.getName().equals("")) continue;
                ret = ret + "__" + arg.getName() + "__";
                continue;
            }
            ret = ret + "__" + arg.getName() + "__:_" + arg.getDatatype() + "_";
        }
        return ret;
    }

    private String writeFunctAnnotations(DwFunction fun) {
        String ret = "";
        DwCommentAnnotation retAnn = null;
        for (DwCommentAnnotation ann : fun.getComment().getAnnotations()) {
            if (ann.getName().toLowerCase().equals(KnitKeyWord.R.getVal()) || ann.getName().toLowerCase().equals(KnitKeyWord.RETURN.getVal())) {
                retAnn = ann;
                continue;
            }
            if (!ann.getName().toLowerCase().equals(KnitKeyWord.P.getVal()) && !ann.getName().toLowerCase().equals(KnitKeyWord.PARAM.getVal())) continue;
            ret = ret + "__param__ `" + ann.getKey() + "` " + Util.stripNewLines(ann.getValue()) + "  " + System.lineSeparator();
        }
        if (retAnn != null) {
            ret = ret + "__return__ " + Util.stripNewLines(retAnn.getValue()) + "  " + System.lineSeparator();
        }
        if (!ret.equals("")) {
            ret = "> " + ret + "> ";
        }
        return ret;
    }

    private String writeAnnotationTable(AnnotationTable tbl) {
        String ret = "";
        ret = ret + "> | " + Util.join(" | ", tbl.getColumns()) + " | " + System.lineSeparator();
        ret = ret + "> | ";
        for (int i = 0; i < tbl.getColumns().size(); ++i) {
            ret = ret + "-|";
        }
        ret = ret + System.lineSeparator();
        for (AnnotationRow row : tbl.getRows()) {
            ret = ret + "> | " + Util.join(" | ", row.getFields()) + " | " + System.lineSeparator();
        }
        return ret;
    }
}

