/*
 * Decompiled with CFR 0.152.
 */
package com.lehman.knit;

import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.element.Text;
import com.lehman.knit.AnnotationRow;
import com.lehman.knit.AnnotationTable;
import com.lehman.knit.DwArgument;
import com.lehman.knit.DwCommentAnnotation;
import com.lehman.knit.DwDocWriter;
import com.lehman.knit.DwFile;
import com.lehman.knit.DwFunction;
import com.lehman.knit.DwVariable;
import com.lehman.knit.KnitKeyWord;
import com.lehman.knit.Util;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class PdfDwDocWriterImpl
implements DwDocWriter {
    private boolean writeHeaderTable = false;
    private String outputHeaderText = "";
    private String outputFooterText = "";

    @Override
    public void setOptions(boolean WriteHeaderTable, String OutputHeaderText, String OutputFooterText) {
        this.writeHeaderTable = WriteHeaderTable;
        this.outputHeaderText = OutputHeaderText;
        this.outputFooterText = OutputFooterText;
    }

    @Override
    public byte[] writeDoc(List<DwFile> files) {
        return this.writeDoc(files, new ArrayList<String>());
    }

    @Override
    public byte[] writeDoc(List<DwFile> files, List<String> moduleNameList) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PdfWriter writer = new PdfWriter((OutputStream)out);
        PdfDocument pdf = new PdfDocument(writer);
        Document doc = new Document(pdf);
        if (!this.outputHeaderText.equals("")) {
            doc.add((IBlockElement)new Paragraph(this.outputHeaderText + System.lineSeparator() + System.lineSeparator()));
        }
        if (this.writeHeaderTable) {
            this.writeHeaderTable(doc, files, moduleNameList);
        }
        for (String modName : moduleNameList) {
            DwFile modFile = this.getFileByModuleName(files, modName);
            if (modFile != null) {
                this.writeDoc(doc, modFile);
                continue;
            }
            System.err.println("Warning: Module name '" + modName + "' was supplied in moduleNameList but was not found parsed file list.");
        }
        for (DwFile dwf : files) {
            if (moduleNameList.contains(dwf.getName())) continue;
            this.writeDoc(doc, dwf);
        }
        if (!this.outputFooterText.equals("")) {
            doc.add((IBlockElement)new Paragraph(this.outputFooterText + System.lineSeparator() + System.lineSeparator()));
        }
        doc.close();
        return out.toByteArray();
    }

    private void writeDoc(Document doc, DwFile file) {
        doc.add((IBlockElement)new Paragraph(this.h1(file.name)));
        doc.add((IBlockElement)new Paragraph(this.h6(Util.join("::", file.modulePath))));
        if (!file.getComment().getText().equals("")) {
            doc.add((IBlockElement)new Paragraph(file.getComment().getText()));
            if (file.getTable() != null) {
                this.writeAnnotationTable(doc, file.getTable());
                doc.add((IBlockElement)new Paragraph(System.lineSeparator()));
            }
        }
        this.writeVariables(doc, file);
        this.writeFunctions(doc, file);
    }

    private void writeHeaderTable(Document doc, List<DwFile> files) {
        this.writeHeaderTable(doc, files, new ArrayList<String>());
    }

    private void writeHeaderTable(Document doc, List<DwFile> files, List<String> moduleNameList) {
        Table table = new Table(2);
        table.addHeaderCell("Module");
        table.addHeaderCell("Description");
        for (String modName : moduleNameList) {
            DwFile modFile = this.getFileByModuleName(files, modName);
            if (modFile != null) {
                table.addCell(modFile.getName());
                table.addCell(Util.stripNewLines(modFile.getComment().getText()));
                continue;
            }
            System.err.println("Warning: Module name '" + modName + "' was supplied in moduleNameList but was not found parsed file list.");
        }
        for (DwFile dwf : files) {
            if (moduleNameList.contains(dwf.getName())) continue;
            table.addCell(dwf.getName());
            table.addCell(Util.stripNewLines(dwf.getComment().getText()));
        }
        doc.add((IBlockElement)table);
    }

    private DwFile getFileByModuleName(List<DwFile> files, String name) {
        DwFile ret = null;
        for (DwFile dwf : files) {
            if (!dwf.getName().equals(name)) continue;
            ret = dwf;
            break;
        }
        return ret;
    }

    private void writeVariables(Document doc, DwFile file) {
        if (file.getVariables().size() > 0) {
            doc.add((IBlockElement)new Paragraph(this.h3("Variables")));
            for (DwVariable var : file.getVariables()) {
                Paragraph p = new Paragraph();
                p.add((ILeafElement)new Text("var ").setBold());
                p.add((ILeafElement)new Text(var.getName() + System.lineSeparator()).setItalic());
                doc.add((IBlockElement)p);
                Paragraph ptext = new Paragraph();
                ptext.setMarginLeft(30.0f);
                ptext.add(var.getComment().getText().replaceAll(System.lineSeparator(), "  " + System.lineSeparator()) + System.lineSeparator() + System.lineSeparator());
                doc.add((IBlockElement)ptext);
                if (var.getTable() == null) continue;
                this.writeAnnotationTable(doc, var.getTable());
            }
        }
    }

    private void writeFunctions(Document doc, DwFile file) {
        if (file.getFunctions().size() > 0) {
            doc.add((IBlockElement)new Paragraph(this.h3("Functions")));
            for (DwFunction fun : file.getFunctions()) {
                Paragraph p = new Paragraph();
                p.add((ILeafElement)new Text("fun ").setBold());
                p.add((ILeafElement)new Text(fun.getName()).setItalic());
                p.add((ILeafElement)new Text(" ( "));
                this.writeFunctArgs(p, fun);
                p.add(" ) " + System.lineSeparator() + System.lineSeparator());
                doc.add((IBlockElement)p);
                this.writeFunctAnnotations(doc, fun);
                Paragraph ptext = new Paragraph();
                ptext.setMarginLeft(30.0f);
                ptext.add(Util.stripNewLines(fun.getComment().getText()) + System.lineSeparator() + System.lineSeparator());
                doc.add((IBlockElement)ptext);
                if (fun.getTable() == null) continue;
                this.writeAnnotationTable(doc, fun.getTable());
                doc.add((IBlockElement)new Paragraph(System.lineSeparator()));
            }
        }
    }

    private void writeFunctArgs(Paragraph p, DwFunction fun) {
        for (int i = 0; i < fun.getArguments().size(); ++i) {
            DwArgument arg;
            if (i > 0) {
                p.add((ILeafElement)new Text(", "));
            }
            if ((arg = fun.getArguments().get(i)).getDatatype().equals("")) {
                if (arg.getName().equals("")) continue;
                p.add((ILeafElement)new Text(arg.getName()).setBold());
                continue;
            }
            p.add((ILeafElement)new Text(arg.getName()).setBold());
            p.add((ILeafElement)new Text(":"));
            p.add((ILeafElement)new Text(arg.getDatatype()).setItalic());
        }
    }

    private void writeFunctAnnotations(Document doc, DwFunction fun) {
        Paragraph p = new Paragraph();
        DwCommentAnnotation retAnn = null;
        for (DwCommentAnnotation ann : fun.getComment().getAnnotations()) {
            if (ann.getName().toLowerCase().equals(KnitKeyWord.R.getVal()) || ann.getName().toLowerCase().equals(KnitKeyWord.RETURN.getVal())) {
                retAnn = ann;
                continue;
            }
            if (!ann.getName().toLowerCase().equals(KnitKeyWord.P.getVal()) && !ann.getName().toLowerCase().equals(KnitKeyWord.PARAM.getVal())) continue;
            p.add((ILeafElement)new Text("param ").setBold());
            p.add((ILeafElement)new Text(ann.getKey() + " ").setItalic());
            p.add((ILeafElement)new Text(Util.stripNewLines(ann.getValue()) + "  " + System.lineSeparator()));
        }
        if (retAnn != null) {
            p.add((ILeafElement)new Text("return ").setBold());
            p.add((ILeafElement)new Text(Util.stripNewLines(retAnn.getValue()) + "  " + System.lineSeparator()));
        }
        doc.add((IBlockElement)p);
    }

    private void writeAnnotationTable(Document doc, AnnotationTable tbl) {
        Table table = new Table(tbl.getColumns().size());
        for (String col : tbl.getColumns()) {
            table.addHeaderCell(col);
        }
        for (AnnotationRow row : tbl.getRows()) {
            for (String field : row.getFields()) {
                table.addCell(field);
            }
        }
        doc.add((IBlockElement)table);
    }

    private Text h1(String text) {
        return (Text)((Text)new Text(text).setFontSize(36.0f)).setBold();
    }

    private Text h3(String text) {
        return (Text)new Text(text).setFontSize(24.0f);
    }

    private Text h6(String text) {
        return (Text)new Text(text).setFontSize(16.0f);
    }

    private Text text(String text) {
        return (Text)((Text)new Text(text).setFontSize(12.0f)).setBold();
    }
}

