/*
 * Decompiled with CFR 0.152.
 */
package com.lehman.knit;

import com.lehman.knit.dwArgument;
import com.lehman.knit.dwCommentAnnotation;
import com.lehman.knit.dwDocWriter;
import com.lehman.knit.dwFile;
import com.lehman.knit.dwFunction;
import com.lehman.knit.dwVariable;
import com.lehman.knit.util;
import java.util.ArrayList;
import java.util.List;

public class markdownDwDocWriterImpl
implements dwDocWriter {
    @Override
    public String writeDoc(dwFile file) {
        String functs;
        String ret = "# " + file.name + "\n";
        ret = ret + "###### " + util.join("::", file.modulePath) + "\n";
        if (!file.getComment().getText().equals("")) {
            ret = ret + file.getComment().getText() + "\n";
        }
        ret = ret + "\n";
        String vars = this.writeVariables(file);
        if (!vars.equals("")) {
            ret = ret + "### Variables\n";
            ret = ret + vars + "\n";
        }
        if (!(functs = this.writeFunctions(file)).equals("")) {
            ret = ret + "### Functions\n";
            ret = ret + functs + "\n";
        }
        return ret;
    }

    @Override
    public String writeDoc(List<dwFile> files) {
        return this.writeDoc(files, new ArrayList<String>());
    }

    @Override
    public String writeDoc(List<dwFile> files, List<String> moduleNameList) {
        String ret = "";
        for (String modName : moduleNameList) {
            dwFile modFile = this.getFileByModuleName(files, modName);
            if (modFile != null) {
                ret = ret + this.writeDoc(modFile) + "\n";
                continue;
            }
            System.err.println("Warning: Module name '" + modName + "' was supplied in moduleNameList but was not found parsed file list.");
        }
        for (dwFile dwf : files) {
            if (moduleNameList.contains(dwf.getName())) continue;
            ret = ret + this.writeDoc(dwf) + "\n";
        }
        return ret;
    }

    @Override
    public String writeHeaderTable(List<dwFile> files) {
        return this.writeHeaderTable(files, new ArrayList<String>());
    }

    @Override
    public String writeHeaderTable(List<dwFile> files, List<String> moduleNameList) {
        String ret = "";
        ret = ret + "| Module | Description |\n";
        ret = ret + "|-|-|\n";
        for (String modName : moduleNameList) {
            dwFile modFile = this.getFileByModuleName(files, modName);
            if (modFile != null) {
                ret = ret + "| [" + modFile.getName() + "](#" + modFile.getName() + ") | " + util.stripNewLines(modFile.getComment().getText()) + " |\n";
                continue;
            }
            System.err.println("Warning: Module name '" + modName + "' was supplied in moduleNameList but was not found parsed file list.");
        }
        for (dwFile dwf : files) {
            if (moduleNameList.contains(dwf.getName())) continue;
            ret = ret + "| [" + dwf.getName() + "](#" + dwf.getName() + ") | " + util.stripNewLines(dwf.getComment().getText()) + " |\n";
        }
        ret = ret + "\n";
        return ret;
    }

    private dwFile getFileByModuleName(List<dwFile> files, String name) {
        dwFile ret = null;
        for (dwFile dwf : files) {
            if (!dwf.getName().equals(name)) continue;
            ret = dwf;
            break;
        }
        return ret;
    }

    private String writeVariables(dwFile file) {
        String ret = "";
        for (dwVariable var : file.getVariables()) {
            ret = ret + "__var__ `" + var.getName() + "`\n";
            ret = ret + "> " + var.getComment().getText().replaceAll("\n", "  \n") + "\n\n";
        }
        return ret;
    }

    private String writeFunctions(dwFile file) {
        String ret = "";
        for (dwFunction fun : file.getFunctions()) {
            ret = ret + "__fun__ `" + fun.getName() + "` ( " + this.writeFunctArgs(fun) + ")\n\n";
            ret = ret + this.writeFunctAnnotations(fun) + "\n";
            ret = ret + "> " + util.stripNewLines(fun.getComment().getText()) + "\n\n";
        }
        return ret;
    }

    private String writeFunctArgs(dwFunction fun) {
        String ret = "";
        for (int i = 0; i < fun.getArguments().size(); ++i) {
            dwArgument arg;
            if (i > 0) {
                ret = ret + ", ";
            }
            if ((arg = fun.getArguments().get(i)).getDatatype().equals("")) {
                if (arg.getName().equals("")) continue;
                ret = ret + "__" + arg.getName() + "__";
                continue;
            }
            ret = ret + "__" + arg.getName() + "__:_" + arg.getDatatype() + "_";
        }
        return ret;
    }

    private String writeFunctAnnotations(dwFunction fun) {
        String ret = "";
        dwCommentAnnotation retAnn = null;
        for (dwCommentAnnotation ann : fun.getComment().getAnnotations()) {
            if (ann.getName().toLowerCase().equals("r")) {
                retAnn = ann;
                continue;
            }
            if (!ann.getName().toLowerCase().equals("p")) continue;
            ret = ret + "__param__ `" + ann.getKey() + "` " + util.stripNewLines(ann.getValue()) + "  \n";
        }
        if (retAnn != null) {
            ret = ret + "__return__ " + util.stripNewLines(retAnn.getValue()) + "  \n";
        }
        if (!ret.equals("")) {
            ret = "> " + ret + "> ";
        }
        return ret;
    }
}

