/*
 * Decompiled with CFR 0.152.
 */
package io.github.rushuat.ocell.document;

import io.github.rushuat.ocell.document.Document;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;

public class DocumentBIFF
extends Document {
    public DocumentBIFF() {
        this(null);
    }

    public DocumentBIFF(String password) {
        super((Workbook)new HSSFWorkbook(), password);
    }

    @Override
    public void fromStream(InputStream stream) throws IOException {
        try (InputStream inputStream = stream;
             Workbook book = this.workbook.getWorkbook();){
            if (this.password == null) {
                this.workbook.setWorkbook((Workbook)new HSSFWorkbook(stream));
            } else {
                Biff8EncryptionKey.setCurrentUserPassword((String)new String(this.password));
                this.workbook.setWorkbook((Workbook)new HSSFWorkbook(stream));
                Biff8EncryptionKey.setCurrentUserPassword(null);
            }
        }
    }

    @Override
    public void toStream(OutputStream stream) throws IOException {
        try (OutputStream outputStream = stream;){
            Workbook book = this.workbook.getWorkbook();
            if (this.password == null) {
                book.write(stream);
            } else {
                Biff8EncryptionKey.setCurrentUserPassword((String)new String(this.password));
                book.write(stream);
                Biff8EncryptionKey.setCurrentUserPassword(null);
            }
        }
    }
}

