/*
 * Decompiled with CFR 0.152.
 */
package io.github.rushuat.ocell.document;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public abstract class DocumentIO
implements Closeable {
    public abstract void fromStream(InputStream var1) throws IOException;

    public void fromBytes(byte[] bytes) throws IOException {
        this.fromStream(new ByteArrayInputStream(bytes));
    }

    public void fromFile(File file) throws IOException {
        this.fromStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public void fromFile(String path) throws IOException {
        this.fromFile(new File(path));
    }

    public abstract void toStream(OutputStream var1) throws IOException;

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.toStream(outputStream);
        return outputStream.toByteArray();
    }

    public void toFile(File file) throws IOException {
        Files.write(file.toPath(), this.toBytes(), new OpenOption[0]);
    }

    public void toFile(String path) throws IOException {
        this.toFile(new File(path));
    }
}

