/*
 * Decompiled with CFR 0.152.
 */
package io.github.rushuat.ocell.document;

import io.github.rushuat.ocell.document.Document;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DocumentOOXML
extends Document {
    public DocumentOOXML() {
        this(null);
    }

    public DocumentOOXML(String password) {
        super((Workbook)new XSSFWorkbook(), password);
    }

    @Override
    public void fromStream(InputStream stream) throws IOException {
        block27: {
            try (InputStream inputStream = stream;
                 Workbook book = this.workbook.getWorkbook();){
                if (this.password == null) {
                    this.workbook.setWorkbook((Workbook)new XSSFWorkbook(stream));
                    break block27;
                }
                try (POIFSFileSystem fileSystem = new POIFSFileSystem(stream);){
                    EncryptionInfo encryptionInfo = new EncryptionInfo(fileSystem);
                    Decryptor decryptor = Decryptor.getInstance((EncryptionInfo)encryptionInfo);
                    if (decryptor.verifyPassword(new String(this.password))) {
                        try (InputStream inputStream2 = decryptor.getDataStream(fileSystem);){
                            this.workbook.setWorkbook((Workbook)new XSSFWorkbook(inputStream2));
                            break block27;
                        }
                    }
                    throw new IOException("Invalid document password");
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
            }
        }
    }

    @Override
    public void toStream(OutputStream stream) throws IOException {
        block20: {
            try (OutputStream outputStream = stream;){
                Workbook book = this.workbook.getWorkbook();
                if (this.password == null) {
                    book.write(stream);
                    break block20;
                }
                EncryptionInfo encryptionInfo = new EncryptionInfo(EncryptionMode.standard);
                Encryptor encryptor = encryptionInfo.getEncryptor();
                encryptor.confirmPassword(new String(this.password));
                try (POIFSFileSystem fileSystem = new POIFSFileSystem();){
                    try (OutputStream fileStream = encryptor.getDataStream(fileSystem);){
                        book.write(fileStream);
                    }
                    fileSystem.writeFilesystem(stream);
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
            }
        }
    }
}

