/*
 * Decompiled with CFR 0.152.
 */
package io.github.rushuat.ocell.model;

import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;

public class DocumentCell {
    private final Cell cell;

    public DocumentCell(Cell cell) {
        this.cell = cell;
    }

    public void setStyle(CellStyle style) {
        this.cell.setCellStyle(style);
    }

    public <E> void setValue(E obj) {
        if (obj != null) {
            if (obj instanceof String) {
                this.cell.setCellValue((String)obj);
            } else if (obj instanceof Boolean) {
                this.cell.setCellValue(((Boolean)obj).booleanValue());
            } else if (obj instanceof Number) {
                this.cell.setCellValue(((Number)obj).doubleValue());
            } else if (obj instanceof Date) {
                this.cell.setCellValue((Date)obj);
            }
        }
    }

    public <V> V getValue() {
        Object value = null;
        if (this.cell != null) {
            switch (this.cell.getCellType()) {
                case STRING: {
                    value = this.cell.getStringCellValue();
                    break;
                }
                case BOOLEAN: {
                    value = this.cell.getBooleanCellValue();
                    break;
                }
                case NUMERIC: {
                    value = DateUtil.isCellDateFormatted((Cell)this.cell) ? this.cell.getDateCellValue() : Double.valueOf(this.cell.getNumericCellValue());
                    break;
                }
                default: {
                    value = null;
                }
            }
        }
        return (V)value;
    }
}

