/*
 * Decompiled with CFR 0.152.
 */
package io.github.rushuat.ocell.model;

import io.github.rushuat.ocell.field.Alignment;
import io.github.rushuat.ocell.field.Format;
import io.github.rushuat.ocell.model.DocumentWorkbook;
import io.github.rushuat.ocell.reflection.DocumentField;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class DocumentHeader {
    private final Row header;
    private final Map<Integer, String> nameByIndex;
    private final Map<String, Integer> indexByName;

    public DocumentHeader(DocumentWorkbook workbook, Row header, List<DocumentField> fields) {
        if (header.getLastCellNum() < 0) {
            IntStream.range(0, fields.size()).forEach(index -> {
                DocumentField documentField = (DocumentField)fields.get(index);
                String name = documentField.getName();
                Alignment alignment = documentField.getHeader();
                Format format = new Format(null, false);
                Cell cell = header.createCell(index);
                cell.setCellStyle(workbook.getCellStyle(format, alignment));
                cell.setCellValue(name);
            });
        }
        this.header = header;
        this.nameByIndex = this.getNameByIndexMap();
        this.indexByName = this.getIndexByNameMap();
    }

    private Map<Integer, String> getNameByIndexMap() {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        IntStream.range(0, this.header.getLastCellNum()).filter(index -> Objects.nonNull(this.header.getCell(index))).forEach(index -> map.put(index, this.header.getCell(index).getStringCellValue().trim()));
        return map;
    }

    private Map<String, Integer> getIndexByNameMap() {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        IntStream.range(0, this.header.getLastCellNum()).filter(index -> Objects.nonNull(this.header.getCell(index))).forEach(index -> map.put(this.header.getCell(index).getStringCellValue().trim(), index));
        return map;
    }

    public Integer getIndex(String name) {
        return this.indexByName.get(name);
    }

    public String getName(Integer index) {
        return this.nameByIndex.get(index);
    }

    public Set<Integer> getIndexes() {
        return this.nameByIndex.keySet();
    }

    public Set<String> getNames() {
        return this.indexByName.keySet();
    }
}

