/*
 * Decompiled with CFR 0.152.
 */
package io.github.rushuat.ocell.model;

import io.github.rushuat.ocell.model.DocumentCell;
import io.github.rushuat.ocell.model.DocumentHeader;
import io.github.rushuat.ocell.model.DocumentWorkbook;
import io.github.rushuat.ocell.reflection.DocumentField;
import java.util.List;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class DocumentRow<T> {
    private final DocumentWorkbook workbook;
    private final Row row;
    private final DocumentHeader header;
    private final List<DocumentField> fields;

    public DocumentRow(DocumentWorkbook workbook, Row row, DocumentHeader header, List<DocumentField> fields) {
        this.workbook = workbook;
        this.row = row;
        this.header = header;
        this.fields = fields;
    }

    public void setCells(T item) {
        this.fields.stream().filter(field -> Objects.nonNull(this.header.getIndex(field.getName()))).forEach(field -> {
            Integer index = this.header.getIndex(field.getName());
            Cell cell = this.row.createCell(index.intValue());
            DocumentCell documentCell = new DocumentCell(cell);
            documentCell.setStyle(this.workbook.getCellStyle((DocumentField)field));
            documentCell.setValue(field.getValue(item));
        });
    }

    public T getCells(T item) {
        this.fields.stream().filter(field -> Objects.nonNull(this.header.getIndex(field.getName()))).forEach(field -> {
            Integer index = this.header.getIndex(field.getName());
            Cell cell = this.row.getCell(index.intValue());
            DocumentCell documentCell = new DocumentCell(cell);
            field.setValue(item, documentCell.getValue());
        });
        return item;
    }
}

