/*
 * Decompiled with CFR 0.152.
 */
package io.github.rushuat.ocell.model;

import io.github.rushuat.ocell.model.DocumentHeader;
import io.github.rushuat.ocell.model.DocumentRow;
import io.github.rushuat.ocell.model.DocumentWorkbook;
import io.github.rushuat.ocell.reflection.DocumentClass;
import io.github.rushuat.ocell.reflection.DocumentField;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class DocumentSheet<T> {
    private final DocumentWorkbook workbook;
    private final Sheet sheet;
    private int headerOffset;
    private int dataOffset;
    private DocumentHeader header;
    private final DocumentClass<T> clazz;
    private final List<DocumentField> fields;

    public DocumentSheet(DocumentWorkbook workbook, Sheet sheet, DocumentClass<T> clazz) {
        this(workbook, sheet, 0, 1, clazz);
    }

    public DocumentSheet(DocumentWorkbook workbook, Sheet sheet, int headerOffset, int dataOffset, DocumentClass<T> clazz) {
        this.workbook = workbook;
        this.sheet = sheet;
        this.clazz = clazz;
        this.fields = clazz.getFields();
        this.initOffset(headerOffset, dataOffset);
        this.initHeader();
    }

    private void initOffset(int headerOffset, int dataOffset) {
        this.headerOffset = headerOffset;
        this.dataOffset = dataOffset <= headerOffset ? headerOffset + 1 : dataOffset;
    }

    private void initHeader() {
        Row row = this.sheet.getLastRowNum() > 0 ? this.sheet.getRow(this.headerOffset) : Optional.ofNullable(this.sheet.getRow(0)).orElse(this.sheet.createRow(0));
        this.header = new DocumentHeader(this.workbook, row, this.fields);
    }

    public void addRows(Collection<T> items) {
        items.forEach(item -> {
            Row row = this.sheet.createRow(this.sheet.getLastRowNum() + 1);
            DocumentRow<Object> documentRow = new DocumentRow<Object>(this.workbook, row, this.header, this.fields);
            documentRow.setCells(item);
        });
    }

    public List<T> getRows() {
        return IntStream.range(this.dataOffset, this.sheet.getLastRowNum() + 1).mapToObj(index -> {
            T item = this.clazz.newInstance();
            Row row = this.sheet.getRow(index);
            DocumentRow<T> documentRow = new DocumentRow<T>(this.workbook, row, this.header, this.fields);
            return documentRow.getCells(item);
        }).collect(Collectors.toList());
    }

    public void autoSize() {
        this.header.getIndexes().forEach(arg_0 -> ((Sheet)this.sheet).autoSizeColumn(arg_0));
    }
}

