/*
 * Decompiled with CFR 0.152.
 */
package io.github.rushuat.ocell.reflection;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.github.rushuat.ocell.annotation.ClassName;
import io.github.rushuat.ocell.field.ValueConverter;
import io.github.rushuat.ocell.reflection.DocumentField;
import java.lang.reflect.Field;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlRootElement;

public class DocumentClass<T> {
    private final Class<T> clazz;
    private final Map<Class<? extends ValueConverter>, ValueConverter> converterCache;

    public DocumentClass(Class<T> clazz) {
        this.clazz = clazz;
        this.converterCache = new ConcurrentHashMap<Class<? extends ValueConverter>, ValueConverter>();
    }

    public DocumentClass(T element) {
        this(element.getClass());
    }

    public DocumentClass(T[] array) {
        this(array.getClass().getComponentType());
    }

    public Map<Integer, String> getNameByIndexMap() {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        List<DocumentField> fields = this.getFields();
        IntStream.range(0, fields.size()).forEach(index -> map.put(index, ((DocumentField)fields.get(index)).getName()));
        return map;
    }

    public Map<String, Integer> getIndexByNameMap() {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        List<DocumentField> fields = this.getFields();
        IntStream.range(0, fields.size()).forEach(index -> map.put(((DocumentField)fields.get(index)).getName(), index));
        return map;
    }

    public List<DocumentField> getFields() {
        JsonPropertyOrder propertyOrder;
        XmlAccessorOrder accessorOrder;
        ArrayList<DocumentField> fields = new ArrayList<DocumentField>();
        for (Class<T> subclass = this.clazz; subclass != Object.class; subclass = subclass.getSuperclass()) {
            Arrays.stream(subclass.getDeclaredFields()).map(field -> new DocumentField((Field)field, this.converterCache)).filter(Predicate.not(DocumentField::isExcluded)).forEach(fields::add);
        }
        fields.sort(Comparator.comparing(DocumentField::getOrder));
        if (this.clazz.isAnnotationPresent(XmlAccessorOrder.class) && (accessorOrder = this.clazz.getAnnotation(XmlAccessorOrder.class)).value() == XmlAccessOrder.ALPHABETICAL) {
            fields.sort(Comparator.comparing(DocumentField::getName, Collator.getInstance()));
        }
        if (this.clazz.isAnnotationPresent(JsonPropertyOrder.class) && (propertyOrder = this.clazz.getAnnotation(JsonPropertyOrder.class)).alphabetic()) {
            fields.sort(Comparator.comparing(DocumentField::getName, Collator.getInstance()));
        }
        return fields;
    }

    public String getName() {
        String name = null;
        if (this.clazz.isAnnotationPresent(Entity.class)) {
            name = this.clazz.getAnnotation(Entity.class).name();
        }
        if (this.clazz.isAnnotationPresent(Table.class)) {
            name = this.clazz.getAnnotation(Table.class).name();
        }
        if (this.clazz.isAnnotationPresent(XmlRootElement.class)) {
            name = this.clazz.getAnnotation(XmlRootElement.class).name();
        }
        if (this.clazz.isAnnotationPresent(JsonTypeName.class)) {
            name = this.clazz.getAnnotation(JsonTypeName.class).value();
        }
        if (this.clazz.isAnnotationPresent(ClassName.class)) {
            name = this.clazz.getAnnotation(ClassName.class).value();
        }
        if (name == null || name.isBlank()) {
            name = this.clazz.getSimpleName();
        }
        return name;
    }

    public Class<T> getType() {
        return this.clazz;
    }

    public T newInstance() {
        return this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

