/*
 * Decompiled with CFR 0.152.
 */
package io.github.rushuat.ocell.reflection;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.rushuat.ocell.annotation.BooleanValue;
import io.github.rushuat.ocell.annotation.CharValue;
import io.github.rushuat.ocell.annotation.DateValue;
import io.github.rushuat.ocell.annotation.EnumValue;
import io.github.rushuat.ocell.annotation.FieldAlignment;
import io.github.rushuat.ocell.annotation.FieldConverter;
import io.github.rushuat.ocell.annotation.FieldExclude;
import io.github.rushuat.ocell.annotation.FieldFormat;
import io.github.rushuat.ocell.annotation.FieldName;
import io.github.rushuat.ocell.annotation.FieldOrder;
import io.github.rushuat.ocell.annotation.HeaderAlignment;
import io.github.rushuat.ocell.annotation.NumberValue;
import io.github.rushuat.ocell.annotation.StringValue;
import io.github.rushuat.ocell.field.Alignment;
import io.github.rushuat.ocell.field.Format;
import io.github.rushuat.ocell.field.ValueConverter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

public class DocumentField {
    private final Field field;
    private final Map<Class<? extends ValueConverter>, ValueConverter> converterCache;

    public DocumentField(Field field, Map<Class<? extends ValueConverter>, ValueConverter> converterCache) {
        this.field = field;
        this.field.setAccessible(true);
        this.converterCache = converterCache;
    }

    public void setValue(Object obj, Object value) {
        Object data = value;
        Class type = Optional.ofNullable(this.getSubtype()).filter(sub -> !sub.equals(this.getType())).orElseGet(() -> this.getType());
        data = Optional.ofNullable(this.getEnum(data, type)).orElse(data);
        data = Optional.ofNullable(this.getNumber(data, type)).orElse(data);
        ValueConverter converter = this.getConverter();
        if (converter != null) {
            data = converter.convertInput(data);
        }
        if (data == null) {
            data = this.getDefault();
        }
        this.field.set(obj, data);
    }

    public Object getValue(Object obj) {
        ValueConverter converter;
        Object value = this.field.get(obj);
        if (value == null) {
            value = this.getDefault();
        }
        if ((converter = this.getConverter()) != null) {
            value = converter.convertOutput(value);
        }
        if (value instanceof Enum) {
            value = ((Enum)value).name();
        }
        return value;
    }

    public Object getEnum(Object value, Class<?> type) {
        Object data = null;
        if (value instanceof String && type.isEnum()) {
            for (Object item : type.getEnumConstants()) {
                if (!((Enum)item).name().equals(value)) continue;
                data = item;
            }
        }
        return data;
    }

    public Object getNumber(Object value, Class<?> type) {
        Number data = null;
        if (value instanceof Number) {
            if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                data = ((Number)value).doubleValue();
            } else if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                data = ((Number)value).intValue();
            } else if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                data = ((Number)value).longValue();
            } else if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                data = Float.valueOf(((Number)value).floatValue());
            } else if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
                data = ((Number)value).byteValue();
            } else if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                data = ((Number)value).shortValue();
            }
        }
        return data;
    }

    public Object getDefault() {
        Object value = null;
        if (this.field.isAnnotationPresent(BooleanValue.class)) {
            value = this.field.getAnnotation(BooleanValue.class).value();
        } else if (this.field.isAnnotationPresent(StringValue.class)) {
            value = this.field.getAnnotation(StringValue.class).value();
        } else if (this.field.isAnnotationPresent(CharValue.class)) {
            value = Character.valueOf(this.field.getAnnotation(CharValue.class).value());
        } else if (this.field.isAnnotationPresent(NumberValue.class)) {
            Double number = this.field.getAnnotation(NumberValue.class).value();
            value = this.getNumber(number, this.getType());
        } else if (this.field.isAnnotationPresent(EnumValue.class)) {
            String name = this.field.getAnnotation(EnumValue.class).value();
            value = this.getEnum(name, this.getType());
        } else if (this.field.isAnnotationPresent(DateValue.class)) {
            String date = this.field.getAnnotation(DateValue.class).value();
            Format format = this.getFormat();
            SimpleDateFormat formatter = format.getPattern() == null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'") : new SimpleDateFormat(format.getPattern());
            value = formatter.parse(date);
        }
        return value;
    }

    public Format getFormat() {
        FieldFormat fieldFormat;
        JsonFormat jsonFormat;
        String pattern = null;
        if (this.field.isAnnotationPresent(JsonFormat.class) && !(jsonFormat = this.field.getAnnotation(JsonFormat.class)).pattern().isBlank()) {
            pattern = jsonFormat.pattern();
        }
        if (this.field.isAnnotationPresent(FieldFormat.class) && !(fieldFormat = this.field.getAnnotation(FieldFormat.class)).value().isBlank()) {
            pattern = fieldFormat.value();
        }
        Class<?> type = this.getType();
        boolean isDate = type.equals(Date.class);
        return new Format(pattern, isDate);
    }

    public Alignment getAlignment() {
        Alignment alignment = new Alignment();
        if (this.field.isAnnotationPresent(FieldAlignment.class)) {
            FieldAlignment fieldAlignment = this.field.getAnnotation(FieldAlignment.class);
            if (!fieldAlignment.horizontal().isBlank()) {
                alignment.setHorizontal(fieldAlignment.horizontal().toUpperCase());
            }
            if (!fieldAlignment.vertical().isBlank()) {
                alignment.setVertical(fieldAlignment.vertical().toUpperCase());
            }
        }
        return alignment;
    }

    public Alignment getHeader() {
        Alignment alignment = new Alignment();
        if (this.field.isAnnotationPresent(HeaderAlignment.class)) {
            HeaderAlignment headerAlignment = this.field.getAnnotation(HeaderAlignment.class);
            if (!headerAlignment.horizontal().isBlank()) {
                alignment.setHorizontal(headerAlignment.horizontal().toUpperCase());
            }
            if (!headerAlignment.vertical().isBlank()) {
                alignment.setVertical(headerAlignment.vertical().toUpperCase());
            }
        }
        return alignment;
    }

    public Integer getOrder() {
        int order = -1;
        if (this.field.isAnnotationPresent(JsonProperty.class)) {
            order = this.field.getAnnotation(JsonProperty.class).index();
        }
        if (this.field.isAnnotationPresent(FieldOrder.class)) {
            order = this.field.getAnnotation(FieldOrder.class).value();
        }
        return order < 0 ? Integer.MAX_VALUE : order;
    }

    public boolean isExcluded() {
        boolean excluded = false;
        if (Modifier.isStatic(this.field.getModifiers())) {
            excluded = true;
        }
        if (Modifier.isTransient(this.field.getModifiers())) {
            excluded = true;
        }
        if (this.field.isAnnotationPresent(Transient.class)) {
            excluded = true;
        }
        if (this.field.isAnnotationPresent(XmlTransient.class)) {
            excluded = true;
        }
        if (this.field.isAnnotationPresent(JsonIgnore.class)) {
            excluded = this.field.getAnnotation(JsonIgnore.class).value();
        }
        if (this.field.isAnnotationPresent(FieldExclude.class)) {
            excluded = this.field.getAnnotation(FieldExclude.class).value();
        }
        return excluded;
    }

    public String getName() {
        String name = null;
        if (this.field.isAnnotationPresent(Column.class)) {
            name = this.field.getAnnotation(Column.class).name();
        }
        if (this.field.isAnnotationPresent(XmlAttribute.class)) {
            name = this.field.getAnnotation(XmlAttribute.class).name();
        }
        if (this.field.isAnnotationPresent(XmlElement.class)) {
            name = this.field.getAnnotation(XmlElement.class).name();
        }
        if (this.field.isAnnotationPresent(JsonProperty.class)) {
            name = this.field.getAnnotation(JsonProperty.class).value();
        }
        if (this.field.isAnnotationPresent(FieldName.class)) {
            name = this.field.getAnnotation(FieldName.class).value();
        }
        if (name == null || name.isBlank()) {
            name = this.field.getName();
        }
        return name;
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public Class<?> getSubtype() {
        Class type = null;
        ValueConverter converter = this.getConverter();
        if (converter != null) {
            Class<?> clazz = converter.getClass();
            ParameterizedType generic = (ParameterizedType)clazz.getGenericInterfaces()[0];
            type = (Class)generic.getActualTypeArguments()[1];
        }
        return type;
    }

    public ValueConverter getConverter() {
        ValueConverter converter = null;
        if (this.field.isAnnotationPresent(FieldConverter.class)) {
            Class<? extends ValueConverter> clazz = this.field.getAnnotation(FieldConverter.class).value();
            converter = this.converterCache.computeIfAbsent(clazz, this::newConverter);
        }
        return converter;
    }

    private ValueConverter newConverter(Class<? extends ValueConverter> clazz) {
        return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

