/*
 * Decompiled with CFR 0.152.
 */
package com.functionaltools.functionalutils;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public final class Identity<T> {
    private final T value;

    private Identity(T value) {
        this.value = Objects.requireNonNull(value, "Identity value must not be null");
    }

    public static <T> Identity<T> of(T value) {
        Objects.requireNonNull(value, "Identity value must not be null");
        return new Identity<T>(value);
    }

    public T get() {
        return this.value;
    }

    public <U> Identity<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper must not be null");
        return Identity.of(mapper.apply(this.value));
    }

    public <U> U in(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper must not be null");
        return mapper.apply(this.value);
    }

    public Stream<T> stream() {
        return Stream.of(this.value);
    }
}

