/*
 * Decompiled with CFR 0.152.
 */
package com.functionaltools.functionalutils;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public final class Using<T> {
    private final T value;

    private Using(T value) {
        this.value = Objects.requireNonNull(value, "Using value must not be null");
    }

    public static <T> Using<T> using(T value) {
        Objects.requireNonNull(value, "Using value must not be null");
        return new Using<T>(value);
    }

    public T get() {
        return this.value;
    }

    public <U> Using<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper must not be null");
        return Using.using(mapper.apply(this.value));
    }

    public <U> U in(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper must not be null");
        return mapper.apply(this.value);
    }

    public Stream<T> stream() {
        return Stream.of(this.value);
    }
}

