/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.configuration.tags;

import nl.uu.cs.ape.configuration.APEConfigException;
import nl.uu.cs.ape.configuration.tags.APEConfigDefaultValue;
import nl.uu.cs.ape.configuration.tags.validation.ValidationResults;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class APEConfigTag<T> {
    private T value;

    public abstract String getTagName();

    public abstract String getLabel();

    public abstract TagType getType();

    public abstract String getDescription();

    protected JSONObject getTagConstraints() {
        return new JSONObject();
    }

    protected abstract T constructFromJSON(JSONObject var1);

    public abstract APEConfigDefaultValue<T> getDefault();

    public T getValue() {
        if (this.value != null) {
            return this.value;
        }
        APEConfigDefaultValue<T> _default = this.getDefault();
        if (_default.hasValue()) {
            return _default.get();
        }
        throw APEConfigException.missingTag(this.getTagName());
    }

    public void setValueFromConfig(JSONObject obj) {
        ValidationResults results = this.validateConfig(obj);
        if (results.hasFails()) {
            throw APEConfigException.ruleViolations(results);
        }
        if (obj.has(this.getTagName())) {
            this.value = this.constructFromJSON(obj);
        }
    }

    public void setValue(T value) {
        ValidationResults results = this.validate(value);
        if (results.hasFails()) {
            throw APEConfigException.ruleViolations(results);
        }
        this.value = value;
    }

    public boolean isOptional() {
        return this.getDefault().hasValue();
    }

    public boolean isObligatory() {
        return !this.isOptional();
    }

    public ValidationResults validateConfig(JSONObject json) {
        ValidationResults results = new ValidationResults();
        if (!json.has(this.getTagName())) {
            if (this.isObligatory()) {
                results.add(this.getTagName(), String.format("Value for tag '%s' is missing.", this.getTagName()), false);
            }
            return results;
        }
        try {
            T dummy = this.constructFromJSON(json);
            results.add(this.validate(dummy));
        }
        catch (IllegalArgumentException | APEConfigException | JSONException e) {
            results.add(this.getTagName(), e.getMessage(), false);
        }
        return results;
    }

    public ValidationResults validate(T value) {
        ValidationResults results = new ValidationResults();
        return this.validate(value, results);
    }

    protected abstract ValidationResults validate(T var1, ValidationResults var2);

    public Info<T> getInfo() {
        return new Info(this);
    }

    public static class Info<T> {
        public final String tag_name;
        public final String label;
        public final String description;
        public final boolean optional;
        public final TagType type;
        public final T _default;
        public final JSONObject constraints;

        protected Info(APEConfigTag<T> tag) {
            this.tag_name = tag.getTagName();
            this.label = tag.getLabel();
            this.description = tag.getDescription();
            this.optional = tag.isOptional();
            this.type = tag.getType();
            this._default = this.optional ? tag.getDefault().get() : null;
            this.constraints = tag.getTagConstraints();
        }

        public JSONObject toJSON() {
            JSONObject json = new JSONObject().put("tag", (Object)this.tag_name).put("label", (Object)this.label).put("description", (Object)this.description).put("type", (Object)this.type).put("optional", this.optional);
            if (this.optional) {
                json.put("default", (Object)(this._default == null ? "" : this._default));
            }
            if (!this.constraints.isEmpty()) {
                json.put("constraints", (Object)this.constraints);
            }
            return json;
        }
    }

    public static enum TagType {
        FILE_PATH,
        FOLDER_PATH,
        IRI,
        JSON,
        INTEGER,
        INTEGER_RANGE,
        BOOLEAN,
        ENUM,
        DATA_DIMENSIONS,
        DATA_INSTANCES,
        MODULE;

    }
}

